/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public abstract class BaseQueryExecutor
implements QueryExecutor {
    private static Timer TIMER = new Timer();
    private String description;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final ResultSet execute(SupaQuery query, ResultsProcessor processor, SearchWrapper ... wrappers) throws SiapiException {
        this.assertQueryClass(query);
        return this.createBaseExecutor(query, processor, wrappers).execute();
    }

    public final SupaQuery createQuery(String[] collectionIds, String queryString) throws SiapiException {
        SupaQuery result = this.subParse(collectionIds, queryString);
        this.assertQueryClass(result);
        return result;
    }

    public final SupaQuery createQuery(String ... collectionIds) throws SiapiException {
        SupaQuery result = this.subCreateQuery(collectionIds);
        this.assertQueryClass(result);
        return result;
    }

    private void assertQueryClass(Query result) {
        assert (result == null || this.getQueryClass().isInstance(result));
    }

    protected abstract BaseExecutor createBaseExecutor(SupaQuery var1, ResultsProcessor var2, SearchWrapper[] var3) throws SiapiException;

    protected abstract SupaQuery subParse(String[] var1, String var2) throws SiapiException;

    protected abstract SupaQuery subCreateQuery(String[] var1) throws SiapiException;

    public static SearchWrapper[] toSearchWrappers(SupaQuery supaQuery) throws SiapiException {
        return BaseQueryExecutor.toSearchWrappers(supaQuery.getCollectionIds(), supaQuery.getCredentials());
    }

    public static SearchWrapper[] toSearchWrappers(String[] collectionIds, UserSecurityContext usc) throws SiapiException {
        return BaseQueryExecutor.toSearchWrappers(collectionIds, usc, true);
    }

    private static SearchWrapper[] toSearchWrappers(String[] collectionIds, UserSecurityContext usc, boolean enforeSearchPermission) throws SiapiException {
        ArrayList<SearchWrapper> result = new ArrayList<SearchWrapper>();
        for (int i = 0; i < collectionIds.length; ++i) {
            SearchWrapper wrapper = new SearchWrapper(collectionIds[i], usc);
            if (enforeSearchPermission && !wrapper.canSearchCollection()) continue;
            result.add(wrapper);
        }
        return result.toArray(new SearchWrapper[result.size()]);
    }

    protected static abstract class BaseExecutor {
        protected SupaQuery query;
        protected ResultsProcessor processor;
        protected SearchWrapper[] wrappers;
        TimerTask interruptTask;
        boolean running = true;
        boolean closeAfterExecute;

        public BaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            this.query = query;
            this.processor = processor;
            if (wrappers != null && wrappers.length > 0) {
                this.wrappers = wrappers;
                this.closeAfterExecute = false;
            } else {
                this.wrappers = BaseQueryExecutor.toSearchWrappers(query);
                this.closeAfterExecute = true;
            }
        }

        public void scheduleInterrupt(long delay) {
            if (delay <= 0L) {
                return;
            }
            final Thread currThread = Thread.currentThread();
            this.interruptTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = currThread;
                    synchronized (thread) {
                        if (BaseExecutor.this.running) {
                            currThread.interrupt();
                        }
                    }
                }
            };
            TIMER.schedule(this.interruptTask, delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ResultSet execute() throws SiapiException {
            ResultSet resultSet;
            try {
                resultSet = this.subExecute();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    this.running = false;
                    if (this.interruptTask != null) {
                        this.interruptTask.cancel();
                    }
                }
                if (this.closeAfterExecute) {
                    if (this.interruptTask != null) {
                        Thread.interrupted();
                    }
                    for (SearchWrapper wrapper : this.wrappers) {
                        if (wrapper == null) continue;
                        wrapper.close();
                    }
                }
                this.interruptTask = null;
                throw throwable;
            }
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                this.running = false;
                if (this.interruptTask != null) {
                    this.interruptTask.cancel();
                }
            }
            if (this.closeAfterExecute) {
                if (this.interruptTask != null) {
                    Thread.interrupted();
                }
                for (SearchWrapper wrapper : this.wrappers) {
                    if (wrapper == null) continue;
                    wrapper.close();
                }
            }
            this.interruptTask = null;
            return resultSet;
        }

        protected abstract ResultSet subExecute() throws SiapiException;
    }
}

