/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.normalizer.MimetypeNormalizer;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.html.HTMLParser;
import com.ibm.es.nuvo.util.URLUtils;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.config.ExternalOYEConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class ExternalOYEStellentParser
extends HTMLParser {
    public static final String DOC_API_PATH = "/api/document";

    private static String getDocType(String uri, Metadata metadata) {
        String result = metadata.get("KnownContentType");
        if (result == null || result.length() == 0) {
            result = metadata.get("ContentType");
        }
        if (result == null || result.length() == 0) {
            result = MimetypeNormalizer.normalize(URLUtils.getFileExtension(uri));
        }
        if (result == null || result.length() == 0) {
            result = "unknown/unknown";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseText(String uri, Metadata metadata, InputStream input, ParserHandler h, String detectedCharset) throws ParserException {
        int statusCode;
        ExternalOYEConfig config = ConfigurationLoader.getGlobalConfig().getExternalOYEConfig();
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("ignored", config.getApiPassword());
        client.getState().setCredentials(new AuthScope(config.getHost(), config.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        String extUri = config.getScheme() + "://" + config.getHost() + ":" + config.getPort();
        String apiUri = extUri + DOC_API_PATH;
        PostMethod method = new PostMethod(apiUri);
        String docId = Thread.currentThread().getId() + uri;
        String docType = ExternalOYEStellentParser.getDocType(uri, metadata);
        try {
            method.setDoAuthentication(true);
            method.addRequestHeader("action", "addDocument");
            method.addRequestHeader("collection", "Default");
            method.addRequestHeader("docId", docId);
            method.addRequestHeader("docType", docType);
            method.setRequestBody(input);
            try {
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusLine());
                    System.err.println(method.getResponseBodyAsString());
                }
            }
            finally {
                method.releaseConnection();
            }
            final GetMethod get = new GetMethod(extUri + ContextType.Search.getContextPath());
            get.setQueryString(new NameValuePair[]{new NameValuePair("index", "Default"), new NameValuePair("query", "cache::" + docId)});
            try {
                do {
                    Thread.sleep(100L);
                } while ((statusCode = client.executeMethod((HttpMethod)get)) == 400);
                if (statusCode != 200) {
                    throw new RuntimeException("Can't retrieve document from external OYE. Status code was: " + statusCode);
                }
                final StringBuilder htmlOutput = new StringBuilder();
                input = new InputStream(){
                    private BufferedReader reader;
                    private StringBuilder sBuf;
                    private int readIndex;
                    {
                        this.reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream()));
                        this.sBuf = new StringBuilder();
                        this.readIndex = -1;
                    }

                    public int read() throws IOException {
                        while (this.readIndex < this.sBuf.length()) {
                            if (this.readIndex >= 0) {
                                return this.processReadChar(this.sBuf.charAt(this.readIndex++) & 0xFF);
                            }
                            int i = this.reader.read();
                            if (i < 0) {
                                return i;
                            }
                            char c = (char)i;
                            this.sBuf.append(c);
                            if (c != '>') continue;
                            this.readIndex = this.sBuf.indexOf("<!DOCTYPE html");
                        }
                        return this.processReadChar(this.reader.read());
                    }

                    public void close() throws IOException {
                        this.reader.close();
                    }

                    private int processReadChar(int c) {
                        if (c != -1) {
                            htmlOutput.append((char)c);
                        }
                        return c;
                    }
                };
                super.setCurrentContentType(docType);
                super.parseText(uri, metadata, input, h, detectedCharset);
                metadata.set("_htmlized", htmlOutput.toString());
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (Exception e) {
            throw new ParserException(uri, (Throwable)e);
        }
        try {
            method.setRequestHeader("action", "deleteDocument");
            method.setRequestBody("");
            try {
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusLine());
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (Exception e) {
            System.err.println("An exception occurred when trying to remove the document (" + uri + ") from external OYE:");
            e.printStackTrace();
        }
    }
}

