/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes.replication;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.supa.notes.NotesConfigManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateReplicaInfo {
    public static final int SOCKET_ACCEPT_MAX_TIMEOUT = 30000;
    private HashMap<String, String> pathToServer = null;
    private final String javaMainClass = "com.ibm.supa.notes.replication.ExtractReplicationInfo";
    public final String JAVA_EXE = "java.exe";
    private final String JAVA_UNIX_EXE = "java";
    private String tempDir = GlobalConfiguration.getConfiguration().getTempDirectory();
    private String tempLogFilePath = this.tempDir + File.separator + "supa" + File.separator + "notes" + File.separator + "log.nsf";
    private String tempLogBaseFolder = this.tempDir + File.separator + "supa";
    private ObjectInputStream dis;
    private ServerSocket serverSocket;

    public HashMap<String, String> getPathToServer() {
        return this.pathToServer;
    }

    public void runTask() {
        String logFilePath = NotesConfigManager.getInstance().getUserLogPathInfo();
        if (logFilePath != null) {
            String msg = "Extracting notes replication info from log - ended";
            System.out.println("Extracting notes replication info from log....");
            try {
                this.creatTempLogFile(logFilePath);
                this.updatePathToServerMapping();
            }
            catch (FencedProcessException e) {
                msg = "Extracting notes replication info from log - failed";
            }
            catch (IOException e) {
                msg = "Extracting notes replication info from log - failed";
            }
            catch (InterruptedException e) {
                msg = "Extracting notes replication info from log - failed";
            }
            catch (ClassNotFoundException e) {
                msg = "Extracting notes replication info from log - failed";
            }
            System.out.println(msg);
        }
    }

    private void creatTempLogFile(String logFilePath) throws IOException {
        if (!new File(this.tempLogFilePath).exists()) {
            new File(this.tempDir + File.separator + "supa").mkdir();
            new File(this.tempDir + File.separator + "supa" + File.separator + "notes").mkdir();
            new File(this.tempLogFilePath).createNewFile();
        }
        FileInputStream orgFile = new FileInputStream(new File(logFilePath));
        FileOutputStream tempFile = new FileOutputStream(new File(this.tempLogFilePath));
        FileChannel source = orgFile.getChannel();
        FileChannel target = tempFile.getChannel();
        source.transferTo(0L, source.size(), target);
    }

    public void deleteTempLogBaseFolder() {
        if (new File(this.tempLogBaseFolder).exists()) {
            new File(this.tempLogFilePath).delete();
            new File(this.tempDir + File.separator + "supa" + File.separator + "notes").delete();
            new File(this.tempDir + File.separator + "supa").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePathToServerMapping() throws FencedProcessException, IOException, InterruptedException, ClassNotFoundException {
        Process process = null;
        try {
            String pathVar;
            String[] processArgs;
            ProcessBuilder builder;
            Map<String, String> envMap;
            String envPath;
            String notesPath;
            String notesLibPath;
            GlobalConfiguration config = GlobalConfiguration.getConfiguration();
            File executableFile = null;
            Properties prop = System.getProperties();
            String java_home = prop.getProperty("java.home");
            String java_classpath = prop.getProperty("java.class.path");
            String java_libpath = prop.getProperty("java.library.path");
            File installPathFile = new File(config.getInstallPath());
            String installPath = installPathFile.getCanonicalPath();
            if (config.isWindows()) {
                notesPath = notesLibPath = installPath + "\\notes.windows";
            } else {
                notesLibPath = installPath + "/domino.aix/notes/70030/ibmpow";
                notesPath = notesLibPath + File.pathSeparator + installPath + "/domino.aix/notesdata";
            }
            java_libpath = java_libpath.length() > 0 ? java_libpath + File.pathSeparator + notesLibPath : notesLibPath;
            executableFile = config.isWindows() ? new File(java_home + File.separator + "bin" + File.separator + this.JAVA_EXE) : new File(java_home + File.separator + "bin" + File.separator + this.JAVA_UNIX_EXE);
            java_classpath = java_classpath.replaceAll("\"", "");
            java_libpath = java_libpath.replaceAll("\"", "");
            String dbFullPath = this.tempLogFilePath;
            int portNumber = 0;
            this.serverSocket = new ServerSocket(portNumber);
            if (this.serverSocket != null) {
                portNumber = this.serverSocket.getLocalPort();
            }
            if ((envPath = (envMap = (builder = new ProcessBuilder(processArgs = new String[]{executableFile.getCanonicalPath(), "-cp", java_classpath, "-Djava.library.path=" + java_libpath, this.javaMainClass, dbFullPath, String.valueOf(portNumber)})).environment()).get(pathVar = "PATH")) == null && (envPath = envMap.get(pathVar = "Path")) == null) {
                pathVar = "PATH";
            }
            envPath = envPath != null && envPath.length() > 0 ? notesPath + File.pathSeparator + envPath : notesPath;
            builder.environment().put(pathVar, envPath);
            if (config.isAIX()) {
                builder.environment().put("LIBPATH", java_libpath);
            }
            process = builder.start();
            this.serverSocket.setSoTimeout(30000);
            Socket socket = this.serverSocket.accept();
            this.dis = new ObjectInputStream(socket.getInputStream());
            Thread readInfo = new Thread(){

                public void run() {
                    try {
                        UpdateReplicaInfo.this.pathToServer = (HashMap)UpdateReplicaInfo.this.dis.readObject();
                        UpdateReplicaInfo.this.dis.close();
                        UpdateReplicaInfo.this.serverSocket.close();
                    }
                    catch (Exception e) {
                        UpdateReplicaInfo.this.pathToServer = null;
                    }
                }
            };
            readInfo.setDaemon(true);
            readInfo.start();
            process.waitFor();
        }
        finally {
            if (process != null) {
                process.destroy();
                process = null;
            }
        }
    }
}

