/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes.replication;

import com.ibm.es.nuvo.dataio.server.NotesAccessorException;
import com.ibm.es.nuvo.dataio.server.NotesDocument;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import lotus.domino.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractReplicationInfo {
    public static final int NO_ERROR = 0;
    public static final int EXTRACTION_ERROR = 1;
    private static final int TIMEOUT_TO_END_PROCESS = 60000;
    Session session = null;
    Database database = null;
    String dbPath = "";
    NotesDocument document = null;
    DocumentCollection allDocs = null;
    private boolean isNotesThreadInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                System.exit(1);
            }
        }, 60000L);
        ObjectOutputStream dos = null;
        Socket clientSocket = null;
        String LOCAL_HOST = "127.0.0.1";
        if (args.length != 2) {
            System.exit(1);
        }
        String databasePath = args[0];
        Integer portNumber = Integer.parseInt(args[1]);
        try {
            clientSocket = new Socket("127.0.0.1", (int)portNumber);
            dos = new ObjectOutputStream(clientSocket.getOutputStream());
        }
        catch (UnknownHostException e1) {
            System.exit(1);
        }
        catch (IOException e1) {
            System.exit(1);
        }
        ExtractReplicationInfo eri = new ExtractReplicationInfo();
        try {
            int error = eri.connect(databasePath);
            HashMap<String, String> pathToServer = eri.buildPathToServerMaping();
            try {
                dos.writeObject(pathToServer);
                dos.close();
                clientSocket.close();
            }
            catch (IOException e) {
                System.exit(1);
            }
            eri.disconnect();
            if (error == 0) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (NotesAccessorException e) {
            eri.disconnect();
            System.exit(1);
        }
        finally {
            eri.disconnect();
        }
        eri.disconnect();
        System.exit(0);
    }

    private HashMap<String, String> buildPathToServerMaping() {
        HashMap<String, String> pathToServer = new HashMap<String, String>();
        try {
            String serverName;
            String path;
            View repView = this.database.getView("Replication Events");
            ArrayList<LogTriple> allDocsMD = new ArrayList<LogTriple>();
            ArrayList<LogTriple> allFaultDocs = new ArrayList<LogTriple>();
            Document curDoc = repView.getFirstDocument();
            do {
                try {
                    NotesDocument curDocND = new NotesDocument(curDoc, this.session);
                    String sourceServer = curDocND.getFields().get("SourceServer");
                    String pathname = curDocND.getFields().get("Pathname");
                    String createdtime = curDocND.getFields().get("createdtime");
                    String eventList = curDocND.getFields().get("EventList");
                    if (pathname == null || sourceServer == null) continue;
                    if (eventList == null) {
                        if (sourceServer.equals("")) continue;
                        allDocsMD.add(new LogTriple(pathname, sourceServer, new Long(createdtime)));
                        continue;
                    }
                    if (eventList == null) continue;
                    String newPathName = pathname;
                    if (pathname.contains(",")) {
                        String[] splittedPathName = pathname.split(",");
                        newPathName = splittedPathName[0].trim();
                    }
                    allFaultDocs.add(new LogTriple(newPathName, sourceServer, new Long(createdtime)));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            } while ((curDoc = repView.getNextDocument(curDoc)) != null);
            Collections.sort(allDocsMD, new Comparator<LogTriple>(){

                @Override
                public int compare(LogTriple o1, LogTriple o2) {
                    if (o1.getCreateTime() < o2.createTime) {
                        return 1;
                    }
                    if (o1.getCreateTime() > o2.createTime) {
                        return -1;
                    }
                    return 0;
                }
            });
            Collections.sort(allFaultDocs, new Comparator<LogTriple>(){

                @Override
                public int compare(LogTriple o1, LogTriple o2) {
                    if (o1.getCreateTime() > o2.createTime) {
                        return 1;
                    }
                    if (o1.getCreateTime() < o2.createTime) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (LogTriple cur : allDocsMD) {
                path = cur.getPath();
                serverName = pathToServer.get(path);
                if (serverName != null || cur.getPath() == null) continue;
                pathToServer.put(path, cur.getServerName());
            }
            for (LogTriple cur : allFaultDocs) {
                path = cur.getPath();
                serverName = pathToServer.get(path);
                if (serverName != null || cur.getPath() == null) continue;
                pathToServer.put(path, cur.getServerName());
            }
        }
        catch (NotesException e) {
            e.printStackTrace();
        }
        return pathToServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int connect(String databasePath) throws NotesAccessorException {
        Class<?> clazz;
        Class<?> clazz2 = this.getClass();
        synchronized (clazz2) {
            NotesThread.sinitThread();
            this.isNotesThreadInitialized = true;
        }
        int errorCode = 0;
        String errorString = "No error";
        try {
            clazz = this.getClass();
            synchronized (clazz) {
                this.session = NotesFactory.createSession();
            }
            if (this.session != null) {
                this.database = this.session.getDatabase(null, databasePath, false);
                if (this.database != null) {
                    this.allDocs = this.database.getAllDocuments();
                    this.dbPath = databasePath;
                    if (this.allDocs != null) {
                        return 0;
                    }
                    errorCode = 1000;
                    errorString = "No documents in DB";
                } else {
                    errorCode = 1062;
                    errorString = "Cannot access DB";
                }
            } else {
                errorCode = 1060;
                errorString = "Cannot connect to DB";
            }
        }
        catch (NotesException e) {
            e.printStackTrace();
            this.recycleAll();
            Class<?> clazz3 = this.getClass();
            synchronized (clazz3) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            NotesAccessorException nae = new NotesAccessorException(1060, (Throwable)e);
            throw nae;
        }
        this.recycleAll();
        clazz = this.getClass();
        synchronized (clazz) {
            NotesThread.stermThread();
            this.isNotesThreadInitialized = false;
        }
        throw new NotesAccessorException(errorCode, errorString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (this.isNotesThreadInitialized) {
            this.recycleAll();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            this.dbPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleAllDocs() {
        try {
            if (this.allDocs != null) {
                this.allDocs.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.allDocs = null;
        }
    }

    private void recycleDocument() {
        if (this.document != null) {
            this.document.recycle();
            this.document = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleDatabase() {
        try {
            if (this.database != null) {
                this.database.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.database = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSession() {
        try {
            if (this.session != null) {
                this.session.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.session = null;
        }
    }

    private void recycleAll() {
        this.recycleDocument();
        this.recycleAllDocs();
        this.recycleDatabase();
        this.recycleSession();
    }

    private class LogTriple {
        private String path;
        private String serverName;
        private Long createTime;

        public LogTriple(String path, String serverName, Long createTime) {
            this.path = path;
            this.serverName = serverName;
            this.createTime = createTime;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public String getPath() {
            return this.path;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

