/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes.db;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import com.ibm.supa.notes.NotesConfigManager;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesDBPreCrawlInfo {
    public static final int SOCKET_ACCEPT_MAX_TIMEOUT = 200000;
    private final String javaMainClass = "com.ibm.supa.notes.db.ExtractDBPreCrawlInfo";
    public final String JAVA_EXE = "java.exe";
    private final String JAVA_UNIX_EXE = "java";
    private Map<String, String> urlsModifiedDate = null;
    private Long lastDBModifiedDate = null;
    private boolean canConnect = false;
    private Boolean onlyDBModifiedDate;
    private ObjectInputStream dis;
    private ServerSocket serverSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(String databasePath, String userIdPath, String userPass, Boolean tempOnlyDBModifiedDate) {
        Process process = null;
        this.onlyDBModifiedDate = tempOnlyDBModifiedDate;
        try {
            String pathVar;
            String[] processArgs;
            ProcessBuilder builder;
            Map<String, String> envMap;
            String envPath;
            String notesPath;
            String notesLibPath;
            GlobalConfiguration config = GlobalConfiguration.getConfiguration();
            File executableFile = null;
            Properties prop = System.getProperties();
            String java_home = prop.getProperty("java.home");
            String java_classpath = prop.getProperty("java.class.path");
            String java_libpath = prop.getProperty("java.library.path");
            File installPathFile = new File(config.getInstallPath());
            String installPath = installPathFile.getCanonicalPath();
            if (config.isWindows()) {
                notesPath = notesLibPath = installPath + "\\notes.windows";
            } else {
                notesLibPath = installPath + "/domino.aix/notes/70030/ibmpow";
                notesPath = notesLibPath + File.pathSeparator + installPath + "/domino.aix/notesdata";
            }
            java_libpath = java_libpath.length() > 0 ? java_libpath + File.pathSeparator + notesLibPath : notesLibPath;
            executableFile = config.isWindows() ? new File(java_home + File.separator + "bin" + File.separator + this.JAVA_EXE) : new File(java_home + File.separator + "bin" + File.separator + this.JAVA_UNIX_EXE);
            java_classpath = java_classpath.replaceAll("\"", "");
            java_libpath = java_libpath.replaceAll("\"", "");
            File dbp = FSURIUtil.getFileObject(databasePath);
            String dbFullPath = dbp.getCanonicalPath();
            String decryptedUserPass = null;
            if (userPass != null) {
                try {
                    decryptedUserPass = Encryption.decrypt(userPass, NotesConfigManager.secKey);
                }
                catch (ExtendedException e) {
                    decryptedUserPass = null;
                }
            }
            int portNumber = 0;
            this.serverSocket = new ServerSocket(portNumber);
            if (this.serverSocket != null) {
                portNumber = this.serverSocket.getLocalPort();
            }
            if ((envPath = (envMap = (builder = new ProcessBuilder(processArgs = new String[]{executableFile.getCanonicalPath(), "-cp", java_classpath, "-Djava.library.path=" + java_libpath, this.javaMainClass, dbFullPath, userIdPath, decryptedUserPass, String.valueOf(portNumber), String.valueOf(this.onlyDBModifiedDate)})).environment()).get(pathVar = "PATH")) == null && (envPath = envMap.get(pathVar = "Path")) == null) {
                pathVar = "PATH";
            }
            envPath = envPath != null && envPath.length() > 0 ? notesPath + File.pathSeparator + envPath : notesPath;
            builder.environment().put(pathVar, envPath);
            if (config.isAIX()) {
                builder.environment().put("LIBPATH", java_libpath);
            }
            process = builder.start();
            this.serverSocket.setSoTimeout(200000);
            Socket socket = this.serverSocket.accept();
            this.dis = new ObjectInputStream(socket.getInputStream());
            Thread readInfo = new Thread(){

                public void run() {
                    try {
                        String startSignal = (String)NotesDBPreCrawlInfo.this.dis.readObject();
                        NotesDBPreCrawlInfo.this.lastDBModifiedDate = (Long)NotesDBPreCrawlInfo.this.dis.readObject();
                        if (NotesDBPreCrawlInfo.this.lastDBModifiedDate != null) {
                            NotesDBPreCrawlInfo.this.canConnect = true;
                        }
                        if (!NotesDBPreCrawlInfo.this.onlyDBModifiedDate.booleanValue()) {
                            NotesDBPreCrawlInfo.this.urlsModifiedDate = (Map)NotesDBPreCrawlInfo.this.dis.readObject();
                        }
                        NotesDBPreCrawlInfo.this.dis.close();
                        NotesDBPreCrawlInfo.this.serverSocket.close();
                    }
                    catch (Exception e) {
                        NotesDBPreCrawlInfo.this.urlsModifiedDate = null;
                        NotesDBPreCrawlInfo.this.lastDBModifiedDate = null;
                        NotesDBPreCrawlInfo.this.canConnect = false;
                    }
                }
            };
            readInfo.setDaemon(true);
            readInfo.start();
            process.waitFor();
        }
        catch (Exception e) {
            this.urlsModifiedDate = null;
            this.lastDBModifiedDate = null;
            this.canConnect = false;
        }
        finally {
            if (process != null) {
                process.destroy();
                process = null;
            }
        }
    }

    public Map<String, String> getUrlsModifiedDate() {
        return this.urlsModifiedDate;
    }

    public Long getLastDBModifiedDate() {
        return this.lastDBModifiedDate;
    }

    public boolean canConnect() {
        return this.canConnect;
    }
}

