/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes.db;

import com.ibm.es.nuvo.dataio.server.NotesAccessorException;
import com.ibm.es.nuvo.dataio.server.NotesDocument;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Registration;
import lotus.domino.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractDBPreCrawlInfo {
    public static final int NO_ERROR = 0;
    public static final int EXTRACTION_ERROR = 1;
    private static final int TIMEOUT_FOR_CONNECTION = 240000;
    private static final int TIMEOUT_FOR_DB_ITERATION = 3600000;
    Map<String, String> urlsModifiedDate = null;
    Long lastDBModifiedDate = null;
    Session session = null;
    Database database = null;
    String dbPath = "";
    NotesDocument document = null;
    DocumentCollection allDocs = null;
    private boolean isNotesThreadInitialized;
    private static Timer connectionTimer = new Timer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        connectionTimer.schedule(new TimerTask(){

            public void run() {
                System.exit(1);
            }
        }, 240000L);
        ObjectOutputStream dos = null;
        Socket clientSocket = null;
        String LOCAL_HOST = "127.0.0.1";
        if (args.length != 5) {
            System.exit(1);
        }
        String databasePath = args[0];
        String userIdPath = args[1];
        String decryptedUserPass = args[2];
        Integer portNumber = Integer.parseInt(args[3]);
        Boolean onlyDBModifiedDate = Boolean.parseBoolean(args[4]);
        try {
            clientSocket = new Socket("127.0.0.1", (int)portNumber);
            dos = new ObjectOutputStream(clientSocket.getOutputStream());
            dos.writeObject("Starting");
        }
        catch (UnknownHostException e1) {
            System.exit(1);
        }
        catch (IOException e1) {
            System.exit(1);
        }
        ExtractDBPreCrawlInfo eri = new ExtractDBPreCrawlInfo();
        try {
            int error = eri.connect(databasePath, userIdPath, decryptedUserPass);
            if (!onlyDBModifiedDate.booleanValue()) {
                eri.createAllDocsList();
            }
            try {
                dos.writeObject(eri.getLastDBModifiedDate());
                if (!onlyDBModifiedDate.booleanValue()) {
                    dos.writeObject(eri.getUrlsModifiedDate());
                }
                dos.flush();
                dos.close();
                clientSocket.close();
            }
            catch (IOException e) {
                System.exit(1);
            }
            eri.disconnect();
            if (error == 0) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            eri.disconnect();
            System.exit(1);
        }
        finally {
            eri.disconnect();
        }
        eri.disconnect();
        System.exit(0);
    }

    private void createAllDocsList() throws NotesException {
        this.urlsModifiedDate = new HashMap<String, String>();
        connectionTimer.cancel();
        connectionTimer.purge();
        Timer dbIterationTimer = new Timer();
        dbIterationTimer.schedule(new TimerTask(){

            public void run() {
                System.exit(1);
            }
        }, 3600000L);
        String replicaID = this.database.getReplicaID();
        try {
            String curUrl;
            Document doc = this.allDocs.getFirstDocument();
            if (doc != null) {
                curUrl = replicaID + "/0/" + doc.getUniversalID();
                curUrl = curUrl.trim();
                this.urlsModifiedDate.put(curUrl, new Long(doc.getLastModified().toJavaDate().getTime()).toString());
                this.addAllDocAttachments(doc, curUrl);
            }
            while (doc != null) {
                doc = this.allDocs.getNextDocument(doc);
                curUrl = replicaID + "/0/" + doc.getUniversalID();
                curUrl = curUrl.trim();
                this.urlsModifiedDate.put(curUrl, new Long(doc.getLastModified().toJavaDate().getTime()).toString());
                this.addAllDocAttachments(doc, replicaID + "/0/" + doc.getUniversalID());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAllDocAttachments(Document doc, String preUrl) throws NotesException {
        Vector items = doc.getItems();
        for (Item item : items) {
            EmbeddedObject attachment;
            String filename;
            if (item.getType() != 1084 || (filename = item.getValueString()) == null || (attachment = doc.getAttachment(filename)) == null || attachment.getType() != 1454) continue;
            filename = attachment.getName();
            String encFileName = null;
            try {
                encFileName = URLEncoder.encode(filename, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                encFileName = filename;
            }
            String curUrl = preUrl + "/?NotesEntry=" + encFileName;
            curUrl = curUrl.trim();
            DateTime dt = item.getLastModified();
            if (dt == null) {
                dt = doc.getLastModified();
            }
            this.urlsModifiedDate.put(curUrl, new Long(dt.toJavaDate().getTime()).toString());
        }
    }

    public Map<String, String> getUrlsModifiedDate() {
        return this.urlsModifiedDate;
    }

    public Long getLastDBModifiedDate() {
        return this.lastDBModifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int connect(String databasePath, String userIdPath, String decryptedUserPass) throws NotesAccessorException {
        Class<?> clazz;
        Class<?> clazz2 = this.getClass();
        synchronized (clazz2) {
            NotesThread.sinitThread();
            this.isNotesThreadInitialized = true;
        }
        int errorCode = 0;
        String errorString = "No error";
        try {
            clazz = this.getClass();
            synchronized (clazz) {
                this.session = NotesFactory.createSession();
                if (userIdPath != null && decryptedUserPass != null) {
                    Registration notesReg = this.session.createRegistration();
                    notesReg.switchToID(userIdPath, decryptedUserPass);
                }
            }
            if (this.session != null) {
                this.database = this.session.getDatabase(null, databasePath, false);
                if (this.database != null) {
                    this.lastDBModifiedDate = this.database.getLastModified().toJavaDate().getTime();
                    this.allDocs = this.database.getAllDocuments();
                    this.dbPath = databasePath;
                    if (this.allDocs != null) {
                        return 0;
                    }
                    errorCode = 1000;
                    errorString = "No documents in DB";
                } else {
                    errorCode = 1062;
                    errorString = "Cannot access DB";
                }
            } else {
                errorCode = 1060;
                errorString = "Cannot connect to DB";
            }
        }
        catch (NotesException e) {
            e.printStackTrace();
            this.recycleAll();
            Class<?> notesReg = this.getClass();
            synchronized (notesReg) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            NotesAccessorException nae = new NotesAccessorException(1060, (Throwable)e);
            throw nae;
        }
        this.recycleAll();
        clazz = this.getClass();
        synchronized (clazz) {
            NotesThread.stermThread();
            this.isNotesThreadInitialized = false;
        }
        throw new NotesAccessorException(errorCode, errorString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (this.isNotesThreadInitialized) {
            this.recycleAll();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            this.dbPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleAllDocs() {
        try {
            if (this.allDocs != null) {
                this.allDocs.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.allDocs = null;
        }
    }

    private void recycleDocument() {
        if (this.document != null) {
            this.document.recycle();
            this.document = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleDatabase() {
        try {
            if (this.database != null) {
                this.database.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.database = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSession() {
        try {
            if (this.session != null) {
                this.session.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.session = null;
        }
    }

    private void recycleAll() {
        this.recycleDocument();
        this.recycleAllDocs();
        this.recycleDatabase();
        this.recycleSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugLog(String msg) {
        PrintWriter pw = null;
        try {
            String debugFile = "extractAllUrls.log";
            pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(debugFile, true)));
            pw.println(msg);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable e) {}
        }
    }
}

