/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.supa.notes.NotesFilters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesFiltersImpl
implements NotesFilters {
    private Boolean filterAttachments = false;
    private Boolean filterAttachmentForFilteredDocs = true;
    private Integer minimumOptionals = 1;
    private List<String> optionalsFields = null;
    private List<String> mandatoryFields = null;
    private List<String> forbiddenFields = null;
    private Map<String, String> fieldsPattern = null;
    private Boolean mustHaveContent = false;

    public void setMustHaveContent(Boolean mustHaveContent) {
        this.mustHaveContent = mustHaveContent != null ? mustHaveContent : Boolean.valueOf(false);
    }

    public void setFilterAttachments(Boolean filterAttachments) {
        this.filterAttachments = filterAttachments != null ? filterAttachments : Boolean.valueOf(false);
    }

    public void setFilterAttachmentForFilteredDocs(Boolean filterAttachmentForFilteredDocs) {
        this.filterAttachmentForFilteredDocs = filterAttachmentForFilteredDocs != null ? filterAttachmentForFilteredDocs : Boolean.valueOf(true);
    }

    @Override
    public Boolean getFilterAttachmentForFilteredDocs() {
        return this.filterAttachmentForFilteredDocs;
    }

    @Override
    public Boolean getFilterAttachments() {
        return this.filterAttachments;
    }

    public void setMinimumOptionals(Integer minimumOptionals) {
        this.minimumOptionals = minimumOptionals != null ? minimumOptionals : Integer.valueOf(1);
    }

    public void setOptionalsFields(List<String> optionalsFields) {
        this.optionalsFields = optionalsFields != null ? optionalsFields : new ArrayList<String>();
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields != null ? mandatoryFields : new ArrayList<String>();
    }

    public void setForbiddenFields(List<String> forbiddenFields) {
        this.forbiddenFields = forbiddenFields != null ? forbiddenFields : new ArrayList<String>();
    }

    public void setFieldsPattern(Map<String, String> fieldsPattern) {
        this.fieldsPattern = fieldsPattern;
    }

    @Override
    public Boolean isEssentialDocument(StreamedDocument doc) {
        Metadata md = doc.getMetadata();
        InputStream is = doc.getInputStream();
        if (is == null && this.mustHaveContent.booleanValue()) {
            return false;
        }
        if (md == null) {
            return false;
        }
        if (this.mandatoryFields != null) {
            for (String curField : this.mandatoryFields) {
                if (md.get(curField) != null) continue;
                return false;
            }
        }
        if (this.forbiddenFields != null) {
            for (String curField : this.forbiddenFields) {
                if (md.get(curField) == null) continue;
                return false;
            }
        }
        int numOfOptionalInDoc = 0;
        if (this.optionalsFields != null) {
            for (String curField : this.optionalsFields) {
                if (md.get(curField) != null) {
                    ++numOfOptionalInDoc;
                }
                if (numOfOptionalInDoc < this.minimumOptionals) continue;
                break;
            }
        }
        if (numOfOptionalInDoc < this.minimumOptionals) {
            return false;
        }
        if (this.fieldsPattern != null) {
            for (String curField : this.fieldsPattern.keySet()) {
                Pattern fieldPattern;
                Matcher m;
                String fieldValue = md.get(curField);
                if (fieldValue == null || (m = (fieldPattern = Pattern.compile(this.fieldsPattern.get(curField))).matcher(fieldValue)).matches()) continue;
                return false;
            }
        }
        return true;
    }
}

