/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class NotesConfigManager {
    private static final String CipherAlgorithm = "AES";
    private String notesRegistrationFile = ConfigurationLoader.getSupaDirectoryPath() + File.separator + "notesRegistration.xml";
    public static Key secKey = null;
    private static NotesConfigManager notesConfigManager = null;
    private static final String NotesReg = "notesregistration";
    private static final String VersionAttribute = "version";
    private static final String IdElement = "id";
    private static final String UserIdPath = "useridpath";
    private static final String UserLogPath = "userlogpath";
    private static final String UserPassWord = "userpassword";
    private String userIdPathInfo = null;
    private String userLogPathInfo = null;
    private String userPassWordInfo = null;

    public static boolean isNotesSupported() {
        String enableNotesSupport = null;
        try {
            enableNotesSupport = ConfigurationLoader.getGlobalConfig().getNotesGlobalConfig().getEnableNotesSupport().toLowerCase();
        }
        catch (Exception e) {
            return false;
        }
        if (enableNotesSupport == null) {
            return false;
        }
        return enableNotesSupport.equals("true");
    }

    public static NotesConfigManager getInstance() {
        if (notesConfigManager == null) {
            notesConfigManager = new NotesConfigManager();
        }
        return notesConfigManager;
    }

    private NotesConfigManager() {
    }

    private void writeTo(OutputStream os, String lUserIdPath, String lUserLogPath, String lUserPass) throws IOException, ExtendedException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(NotesReg);
        xmlTagger.writeAttr(VersionAttribute, "1.0");
        xmlTagger.closeTag();
        xmlTagger.startElement(IdElement);
        xmlTagger.startElement(UserIdPath);
        xmlTagger.writeText(lUserIdPath);
        xmlTagger.endElement(UserIdPath);
        xmlTagger.startElement(UserLogPath);
        xmlTagger.writeText(lUserLogPath);
        xmlTagger.endElement(UserLogPath);
        xmlTagger.startElement(UserPassWord);
        xmlTagger.writeText(Encryption.encrypt(lUserPass, secKey));
        xmlTagger.endElement(UserPassWord);
        xmlTagger.endElement(IdElement);
        xmlTagger.endElement(NotesReg);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    public void setUserIdPathInfo(String userIdPathInfo) {
        this.userIdPathInfo = userIdPathInfo;
    }

    public void setUserLogPathInfo(String userLogPathInfo) {
        this.userLogPathInfo = userLogPathInfo;
    }

    public void setUserPassWordInfo(String userPassWordInfo) {
        this.userPassWordInfo = userPassWordInfo;
    }

    private void loadFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String basePath = "/notesregistration/id/";
        tree.addPath(basePath + UserIdPath, "setUserIdPathInfo");
        tree.addPath(basePath + UserLogPath, "setUserLogPathInfo");
        tree.addPath(basePath + UserPassWord, "setUserPassWordInfo");
        parser.parse(is, tree, this);
    }

    public void updateNewRegistration(String userIdPath, String userLogPath, String userPass) throws IOException, Exception {
        FileOutputStream fos = new FileOutputStream(this.notesRegistrationFile);
        this.writeTo(fos, userIdPath, userLogPath, userPass);
        fos.close();
    }

    public String getUserIdPathInfo() {
        try {
            this.loadFrom(new FileInputStream(new File(this.notesRegistrationFile)));
        }
        catch (FileNotFoundException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        catch (ExtendedException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        return this.userIdPathInfo;
    }

    public String getUserLogPathInfo() {
        try {
            this.loadFrom(new FileInputStream(new File(this.notesRegistrationFile)));
        }
        catch (FileNotFoundException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        catch (ExtendedException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        return this.userLogPathInfo;
    }

    public String getUserPassWordInfo() throws IOException, Exception {
        try {
            this.loadFrom(new FileInputStream(new File(this.notesRegistrationFile)));
        }
        catch (FileNotFoundException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        catch (ExtendedException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        if (this.userPassWordInfo != null) {
            String userPassword = Encryption.decrypt(this.userPassWordInfo, secKey);
            this.userPassWordInfo = null;
            return userPassword;
        }
        return null;
    }

    public String getEncryptedUserPassWordInfo() throws IOException, Exception {
        try {
            this.loadFrom(new FileInputStream(new File(this.notesRegistrationFile)));
        }
        catch (FileNotFoundException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        catch (ExtendedException e) {
            this.userIdPathInfo = null;
            this.userLogPathInfo = null;
            this.userPassWordInfo = null;
            return null;
        }
        if (this.userPassWordInfo != null) {
            return this.userPassWordInfo;
        }
        return null;
    }

    static {
        byte[] keyBytes = new byte[]{87, 23, 11, 22, 21, 98, 45, 49, 32, 52, 24, 60, 45, 57, 76, 77};
        secKey = new SecretKeySpec(keyBytes, CipherAlgorithm);
    }
}

