/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.notes;

import com.ibm.supa.notes.NotesConfig;
import com.ibm.supa.notes.NotesFiltersImpl;
import com.ibm.supa.notes.NotesNSFConfig;
import com.ibm.supa.notes.NotesNSFConfigImpl;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesConfigImpl
implements NotesConfig {
    private Map<String, NotesNSFConfig> nsfConfigMap;
    private static final String defaultConfig = "default";

    public void setNsfConfigMap(Map<String, NotesNSFConfig> nsfConfigMap) {
        this.nsfConfigMap = nsfConfigMap;
    }

    @Override
    public NotesNSFConfig getNotesNSFConfig(String nsfFileName) {
        if (this.nsfConfigMap != null) {
            NotesNSFConfig notesNSFConfig = this.nsfConfigMap.get(nsfFileName);
            if (notesNSFConfig != null) {
                return notesNSFConfig;
            }
            notesNSFConfig = this.nsfConfigMap.get(defaultConfig);
            if (notesNSFConfig != null) {
                return notesNSFConfig;
            }
            return this.getSystemDefault();
        }
        return this.getSystemDefault();
    }

    private NotesNSFConfig getSystemDefault() {
        NotesNSFConfigImpl notesNSFConfigImpl = new NotesNSFConfigImpl();
        ArrayList<String> metaDataView = new ArrayList<String>();
        metaDataView.add("subject");
        metaDataView.add("Abstract");
        metaDataView.add("initialsubjectinthread");
        metaDataView.add("ReportName");
        metaDataView.add("WorkCategories");
        metaDataView.add("Category");
        metaDataView.add("ViewAuthor");
        metaDataView.add("from");
        metaDataView.add("fromemailaddress");
        metaDataView.add("to");
        metaDataView.add("toemailaddress");
        metaDataView.add("receivedby");
        metaDataView.add("receivedbyemailaddress");
        metaDataView.add("bcc");
        metaDataView.add("bccemailaddress");
        metaDataView.add("cc");
        metaDataView.add("ccemailaddress");
        metaDataView.add("createdtime");
        metaDataView.add("lastmodifiedtime");
        metaDataView.add("uri");
        notesNSFConfigImpl.setMetaDataView(metaDataView);
        ArrayList<String> subjectPossibleFields = new ArrayList<String>();
        subjectPossibleFields.add("subject");
        subjectPossibleFields.add("Abstract");
        notesNSFConfigImpl.setSubjectPossibleFields(subjectPossibleFields);
        NotesFiltersImpl filters = new NotesFiltersImpl();
        filters.setFieldsPattern(null);
        filters.setFilterAttachmentForFilteredDocs(true);
        filters.setFilterAttachments(false);
        filters.setForbiddenFields(null);
        filters.setMandatoryFields(null);
        filters.setMinimumOptionals(1);
        filters.setMustHaveContent(false);
        ArrayList<String> optionalsFields = new ArrayList<String>();
        optionalsFields.add("subject");
        optionalsFields.add("ReportName");
        optionalsFields.add("initialsubjectinthread");
        optionalsFields.add("Abstract");
        filters.setOptionalsFields(optionalsFields);
        notesNSFConfigImpl.setFilters(filters);
        return notesNSFConfigImpl;
    }
}

