/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.metadata.plugins;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.MetadataPart;
import com.ibm.es.nuvo.plugin.MetadataPluginArg;
import com.ibm.supa.metadata.plugins.ChainedMetadataPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexMetadataPlugin
extends ChainedMetadataPlugin {
    private String readField;
    private Map<Pattern, List<String>> patternMap;
    private String writeField;
    private boolean firstValueOnly;
    private List<String> defaultValues;
    private boolean addToIndex = true;
    private boolean addToMetadata = true;
    private Set<String> valuesToWrite = new HashSet<String>();

    public void setSingleDefaultValue(String value) {
        this.defaultValues = new ArrayList<String>(1);
        this.defaultValues.add(value);
    }

    public void setDefaultValues(List<String> values) {
        this.defaultValues = values;
    }

    public void setPatternMap(Map<String, List<String>> patternMap) {
        this.patternMap = new LinkedHashMap<Pattern, List<String>>();
        for (Map.Entry<String, List<String>> entry : patternMap.entrySet()) {
            this.patternMap.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
    }

    public void setAddToIndex(boolean addToIndex) {
        this.addToIndex = addToIndex;
    }

    public void setAddToMetadata(boolean addToMetadata) {
        this.addToMetadata = addToMetadata;
    }

    public void setPatternSingleValueMap(Map<String, String> patternMap) {
        this.patternMap = new LinkedHashMap<Pattern, List<String>>();
        for (Map.Entry<String, String> entry : patternMap.entrySet()) {
            ArrayList<String> value = new ArrayList<String>(1);
            value.add(entry.getValue());
            this.patternMap.put(Pattern.compile(entry.getKey()), value);
        }
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public void setWriteField(String writeField) {
        this.writeField = writeField;
    }

    public void setFirstValueOnly(boolean firstValueOnly) {
        this.firstValueOnly = firstValueOnly;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean subExecute(MetadataPluginArg arg) {
        if (this.firstValueOnly) {
            String value = arg.getValue(this.readField);
            if (value != null) {
                this.process(value, arg);
            } else {
                List<MetadataPart.Value> values = this.getMetadata().getValues(this.readField);
                if (values != null && !values.isEmpty() && (value = ((Object)values.get(0)).toString()) != null) {
                    this.process(value, arg);
                }
            }
        } else {
            String[] values = arg.getValues(this.readField);
            if (values != null) {
                void var5_7;
                String[] arr$ = values;
                int len$ = arr$.length;
                boolean bl = false;
                while (var5_7 < len$) {
                    String value = arr$[var5_7];
                    this.process(value, arg);
                    ++var5_7;
                }
            } else {
                List<MetadataPart.Value> valuesList = this.getMetadata().getValues(this.readField);
                if (valuesList != null) {
                    for (CharSequence charSequence : valuesList) {
                        if (charSequence == null) continue;
                        this.process(((Object)charSequence).toString(), arg);
                    }
                }
            }
        }
        Collection<String> writeValues = this.valuesToWrite;
        if (this.defaultValues != null && writeValues.isEmpty()) {
            writeValues = this.defaultValues;
        }
        Metadata metadata = null;
        int writeIndex = 0;
        if (this.addToMetadata) {
            metadata = this.getMetadata();
        }
        if (this.addToIndex) {
            try {
                writeIndex = arg.getNumValues(this.writeField) + 1;
            }
            catch (Throwable throwable) {
                String[] values = arg.getValues(this.writeField);
                writeIndex = (values == null ? -1 : values.length) + 1;
            }
        }
        for (String writeValue : writeValues) {
            if (this.addToMetadata && metadata != null) {
                metadata.add(this.writeField, writeValue);
            }
            if (!this.addToIndex) continue;
            arg.setValue(this.writeField, writeIndex, writeValue);
            ++writeIndex;
        }
        this.valuesToWrite.clear();
        return true;
    }

    private void process(String value, MetadataPluginArg arg) {
        for (Map.Entry<Pattern, List<String>> entry : this.patternMap.entrySet()) {
            if (!entry.getKey().matcher(value).matches()) continue;
            this.valuesToWrite.addAll((Collection<String>)entry.getValue());
        }
    }
}

