/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.util;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.File;
import org.apache.lucene.index.IndexReader;

public class DirectoryManager {
    public static final String LUCENE_LINKER_BASE_PATH = "linker";
    public static final String LUCENE_LINKER_INDEX_PATH = "linker/index";
    public static final String COMMON_WORDS = GlobalConfiguration.getConfiguration().getInstallPath() + "/lib/linker/common_words/common_words";

    public static String collectionToLinkerBasePath(String collectionId) {
        String result = ConfigurationLoader.getSupaDirectoryPath(collectionId);
        if (result != null) {
            result = new File(result, LUCENE_LINKER_BASE_PATH).getPath();
        }
        return result;
    }

    public static String collectionToIndexPath(String collectionId) {
        String result = ConfigurationLoader.getSupaDirectoryPath(collectionId);
        if (result != null) {
            result = new File(result, LUCENE_LINKER_INDEX_PATH).getPath();
        }
        return result;
    }

    public static void clearOrMakeAnEmptyIndexFolder(String collectionId) {
        String indexPath = DirectoryManager.collectionToIndexPath(collectionId);
        File folder = new File(indexPath);
        if (folder.exists()) {
            String[] files = folder.list();
            for (int i = 0; i < files.length; ++i) {
                new File(folder, files[i]).delete();
            }
        } else {
            new File(indexPath).mkdirs();
        }
    }

    public static boolean indexExists(String collectionId) {
        return IndexReader.indexExists((String)DirectoryManager.collectionToIndexPath(collectionId));
    }
}

