/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.docInfo;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexerListener;
import com.ibm.es.nuvo.indexer.DocumentIndexerListenerInterface;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.docInfo.DocumentCache;
import com.ibm.supa.search.SearchWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.ReferenceMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCacheImpl
extends DocumentIndexerListener
implements DocumentCache {
    private static final long CACHE_LIFETIME = 600000L;
    private static final int MIN_CACHE_SIZE = 30;
    private ConcurrentHashMap<String, Map<String, TokenizedDocument>> docCaches = new ConcurrentHashMap();
    private FieldSelector fieldSelector;
    private ExecutorService executor;
    private ScheduledExecutorService evictionTimer;
    private ConcurrentHashMap<TokenizedDocument, EvictionTask> evictionTasks;
    private Set<DocumentCache.EvictionHandler> handlers;

    public DocumentCacheImpl() {
        ConcurrentHashMap<String, FieldSelectorResult> fieldsToLoad = new ConcurrentHashMap<String, FieldSelectorResult>();
        fieldsToLoad.put("uri", FieldSelectorResult.LOAD);
        this.fieldSelector = new MapFieldSelector(fieldsToLoad);
        this.executor = SUPAUtils.newDaemonExecutor();
        this.evictionTimer = Executors.newSingleThreadScheduledExecutor(SUPAUtils.DAEMON_THREAD_FACTORY);
        this.evictionTasks = new ConcurrentHashMap();
        this.handlers = new CopyOnWriteArraySet<DocumentCache.EvictionHandler>();
        GlobalSystem.getSingleInstance().getDocumentIndexer().addListener(this);
    }

    @Override
    public void addHandler(DocumentCache.EvictionHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public synchronized void removeHandler(DocumentCache.EvictionHandler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public String getUri(SearchWrapper wrapper, int doc) throws IOException, SiapiException {
        Document document = wrapper.getTextIndexReader().document(doc, this.fieldSelector);
        return document.getField("uri").stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenizedDocument[] load(String collectionId, String ... uris) throws SiapiException, IOException, ExtendedException {
        SearchWrapper wrapper = new SearchWrapper(collectionId, null);
        try {
            TokenizedDocument[] results = new TokenizedDocument[uris.length];
            for (int i = 0; i < results.length; ++i) {
                TermDocs docs = wrapper.getTextIndexReader().termDocs(new Term("uri", uris[i]));
                try {
                    if (!docs.next()) continue;
                    results[i] = this.load(wrapper, uris[i], docs.doc());
                    continue;
                }
                finally {
                    docs.close();
                }
            }
            TokenizedDocument[] tokenizedDocumentArray = results;
            return tokenizedDocumentArray;
        }
        finally {
            wrapper.close();
        }
    }

    @Override
    public TokenizedDocument load(SearchWrapper wrapper, int doc) throws ExtendedException, IOException, SiapiException {
        return this.load(wrapper, this.getUri(wrapper, doc), doc);
    }

    @Override
    public TokenizedDocument load(SearchWrapper wrapper, String uri, int doc) throws ExtendedException, IOException, SiapiException {
        return this.loadDocument(wrapper, uri, doc, this.getDocCache(wrapper));
    }

    private Map<String, TokenizedDocument> getDocCache(SearchWrapper wrapper) {
        return this.getDocCache(wrapper.getCollectionId());
    }

    private Map<String, TokenizedDocument> getDocCache(String collectionId) {
        Map<String, TokenizedDocument> docCache = this.docCaches.get(collectionId);
        if (docCache == null) {
            docCache = Collections.synchronizedMap(new ReferenceMap());
            this.docCaches.putIfAbsent(collectionId, docCache);
            docCache = this.docCaches.get(collectionId);
        }
        return docCache;
    }

    @Override
    public TokenizedDocument load(SearchWrapper wrapper, String uri) throws ExtendedException, IOException, SiapiException {
        TokenizedDocument result = this.loadDocument(uri, this.getDocCache(wrapper));
        if (result == null) {
            Term term = new Term("uri", uri);
            TermDocs docs = wrapper.getTextIndexReader().termDocs(term);
            if (docs.next()) {
                result = this.loadNewDocument(wrapper, uri, docs.doc());
            }
            assert (!docs.next());
        }
        return result;
    }

    private TokenizedDocument loadDocument(SearchWrapper wrapper, String uri, int doc, Map<String, TokenizedDocument> docCache) throws ExtendedException, IOException, SiapiException {
        TokenizedDocument result = this.loadDocument(uri, docCache);
        if (result == null) {
            result = this.loadNewDocument(wrapper, uri, doc);
        }
        return result;
    }

    private TokenizedDocument loadNewDocument(SearchWrapper wrapper, String uri, int doc) throws ExtendedException, IOException, SiapiException {
        return SUPAUtils.completeTask(this.submitLoadNewDocTask(wrapper, uri, doc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenizedDocument loadDocument(String uri, Map<String, TokenizedDocument> docCache) {
        TokenizedDocument result = null;
        Map<String, TokenizedDocument> map = docCache;
        synchronized (map) {
            result = docCache.get(uri);
            if (result != null) {
                this.accessTask(result);
            }
        }
        return result;
    }

    private void accessTask(TokenizedDocument document) {
        this.evictionTasks.get(document).access();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenizedDocument[] load(SearchWrapper wrapper, int ... docs) throws ExtendedException, IOException, SiapiException {
        int i;
        Map<String, TokenizedDocument> docCache;
        TokenizedDocument[] result = new TokenizedDocument[docs.length];
        String[] uris = this.getUris(wrapper, docs);
        boolean allPresent = true;
        Map<String, TokenizedDocument> map = docCache = this.getDocCache(wrapper);
        synchronized (map) {
            for (i = 0; i < docs.length; ++i) {
                result[i] = docCache.get(uris[i]);
                if (result[i] != null) {
                    this.accessTask(result[i]);
                    continue;
                }
                allPresent = false;
            }
        }
        if (!allPresent) {
            LinkedList<FutureTask<TokenizedDocument>> tasks = new LinkedList<FutureTask<TokenizedDocument>>();
            for (i = 0; i < docs.length; ++i) {
                if (result[i] != null) continue;
                tasks.addLast(this.submitLoadNewDocTask(wrapper, uris[i], docs[i]));
            }
            for (i = 0; i < docs.length && !tasks.isEmpty(); ++i) {
                if (result[i] != null) continue;
                result[i] = (TokenizedDocument)SUPAUtils.completeTask((FutureTask)tasks.removeFirst());
            }
        }
        return result;
    }

    private String[] getUris(SearchWrapper wrapper, int ... docs) throws ExtendedException, IOException, SiapiException {
        FutureTask[] uriTasks = new FutureTask[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            uriTasks[i] = this.submitLoadUriTask(wrapper, docs[i]);
        }
        return SUPAUtils.completeTasks(uriTasks, String.class);
    }

    @Override
    public TokenizedDocument[] fetchDocuments(SearchWrapper wrapper, int ... docs) throws ExtendedException, IOException, SiapiException {
        FutureTask[] tasks = new FutureTask[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            tasks[i] = this.submitFetchTask(wrapper, docs[i]);
        }
        return SUPAUtils.completeTasks(tasks, TokenizedDocument.class);
    }

    @Override
    public TokenizedDocument fetchDocument(SearchWrapper wrapper, int doc) throws ExtendedException, IOException, SiapiException {
        return TokenizedDocument.readDocument(wrapper.getTextIndexReader().document(doc));
    }

    private FutureTask<TokenizedDocument> submitFetchTask(final SearchWrapper wrapper, final int doc) {
        FutureTask<TokenizedDocument> task = new FutureTask<TokenizedDocument>(new Callable<TokenizedDocument>(){

            @Override
            public TokenizedDocument call() throws ExtendedException, IOException, SiapiException {
                return DocumentCacheImpl.this.fetchDocument(wrapper, doc);
            }
        });
        this.executor.submit(task);
        return task;
    }

    private FutureTask<TokenizedDocument> submitLoadNewDocTask(final SearchWrapper wrapper, final String uri, final int doc) {
        FutureTask<TokenizedDocument> task = new FutureTask<TokenizedDocument>(new Callable<TokenizedDocument>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TokenizedDocument call() throws ExtendedException, IOException, SiapiException {
                Map docCache;
                TokenizedDocument result = DocumentCacheImpl.this.fetchDocument(wrapper, doc);
                Map map = docCache = DocumentCacheImpl.this.getDocCache(wrapper);
                synchronized (map) {
                    TokenizedDocument old = (TokenizedDocument)docCache.get(uri);
                    if (old == null) {
                        docCache.put(uri, result);
                        EvictionTask task = new EvictionTask(docCache, uri);
                        DocumentCacheImpl.this.evictionTasks.put(result, task);
                        DocumentCacheImpl.this.evictionTimer.schedule(task, 600000L, TimeUnit.MILLISECONDS);
                    } else {
                        result = old;
                        DocumentCacheImpl.this.accessTask(result);
                    }
                }
                return result;
            }
        });
        this.executor.submit(task);
        return task;
    }

    private FutureTask<String> submitLoadUriTask(final SearchWrapper wrapper, final int doc) {
        FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws ExtendedException, IOException, SiapiException {
                return DocumentCacheImpl.this.getUri(wrapper, doc);
            }
        });
        this.executor.submit(task);
        return task;
    }

    @Override
    public void documentOperationSuccessful(String collectionId, BaseDocument document, DocumentIndexerListenerInterface.OperationType operation) {
        this.remove(collectionId, document);
    }

    @Override
    public void documentOperationFailed(String collectionId, BaseDocument document, DocumentIndexerListenerInterface.OperationType operation, ExtendedException exception) {
        this.remove(collectionId, document);
    }

    @Override
    public void indexUpdated(String collectionId) {
        this.removeAll(collectionId);
    }

    private void remove(String collectionId, BaseDocument document) {
        EvictionTask task;
        TokenizedDocument tDoc;
        Map<String, TokenizedDocument> docCache = this.docCaches.get(collectionId);
        if (docCache != null && (tDoc = docCache.get(document.getUri())) != null && (task = this.evictionTasks.get(tDoc)) != null) {
            task.cancel();
        }
    }

    private void removeAll(String collectionId) {
        Map<String, TokenizedDocument> docCache = this.docCaches.remove(collectionId);
        if (docCache != null) {
            ArrayList<EvictionTask> tasks = new ArrayList<EvictionTask>(docCache.size());
            for (TokenizedDocument tDoc : docCache.values()) {
                EvictionTask task;
                if (tDoc == null || (task = this.evictionTasks.get(tDoc)) == null) continue;
                tasks.add(task);
            }
            for (EvictionTask task : tasks) {
                task.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvictionTask
    implements Runnable {
        final Map<String, TokenizedDocument> docCache;
        final String uri;
        ScheduledFuture<?> future;
        long nextRunTime;

        EvictionTask(Map<String, TokenizedDocument> docCache, String uri) {
            this.docCache = docCache;
            this.uri = uri;
            this.nextRunTime = System.currentTimeMillis() + 600000L;
        }

        public synchronized void access() {
            this.nextRunTime = System.currentTimeMillis() + 600000L;
        }

        @Override
        public synchronized void run() {
            long delay = this.getDelay();
            if (delay > 0L) {
                this.future = DocumentCacheImpl.this.evictionTimer.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else if (this.docCache.size() <= 30) {
                this.access();
                this.future = DocumentCacheImpl.this.evictionTimer.schedule(this, 600000L, TimeUnit.MILLISECONDS);
            } else {
                this.cancel();
            }
        }

        private synchronized long getDelay() {
            return this.nextRunTime - System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void cancel() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            TokenizedDocument tDoc = null;
            Map<String, TokenizedDocument> map = this.docCache;
            synchronized (map) {
                tDoc = this.docCache.remove(this.uri);
                if (tDoc != null) {
                    DocumentCacheImpl.this.evictionTasks.remove(tDoc);
                }
            }
            if (tDoc != null) {
                for (DocumentCache.EvictionHandler handler : DocumentCacheImpl.this.handlers) {
                    handler.handleEviction(tDoc);
                }
            }
        }
    }
}

