/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.docInfo;

import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.supa.docInfo.DocContents;
import com.ibm.supa.docInfo.DocContentsCache;
import com.ibm.supa.docInfo.DocumentCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocContentsCacheImpl
implements DocumentCache.EvictionHandler,
DocContentsCache {
    private static final int CACHE_SIZE = 100;
    private Map<String, Map<TokenizedDocument, DocContents>> cache = new HashMap<String, Map<TokenizedDocument, DocContents>>();
    private List<DocumentCache> docCaches;

    public void setDocumentCaches(List<DocumentCache> docCaches) {
        if (this.docCaches != null) {
            for (DocumentCache docCache : docCaches) {
                docCache.removeHandler(this);
            }
        }
        for (DocumentCache docCache : docCaches) {
            docCache.addHandler(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEviction(TokenizedDocument tDoc) {
        Map<String, Map<TokenizedDocument, DocContents>> map = this.cache;
        synchronized (map) {
            for (Map<TokenizedDocument, DocContents> lookup : this.cache.values()) {
                lookup.remove(tDoc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocContents lookup(TokenizedDocument tDoc, String field) {
        Map<TokenizedDocument, DocContents> lookup;
        Map<Object, Object> map = this.cache;
        synchronized (map) {
            lookup = this.cache.get(field);
            if (lookup == null) {
                lookup = Collections.synchronizedMap(new ReferenceMap());
                this.cache.put(field, lookup);
            }
        }
        map = lookup;
        synchronized (map) {
            DocContents result = lookup.get(tDoc);
            if (result == null) {
                result = new DocContents(tDoc, field);
                if (lookup.size() == 100) {
                    Set<TokenizedDocument> keys = lookup.keySet();
                    int target = (int)(Math.random() * (double)keys.size());
                    for (TokenizedDocument key : keys) {
                        if (target == 0) {
                            lookup.remove(key);
                            break;
                        }
                        --target;
                    }
                }
                lookup.put(tDoc, result);
            }
            return result;
        }
    }
}

