/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.docInfo;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.supa.common.SUPAUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DocContents {
    private String field;
    private TokenVectorIterator iter;
    private int endPos;
    private List<EOLInfo> lineInfo;
    private boolean moreLines;
    private ReadWriteLock lock;
    private StringBuilder sBuf;

    public DocContents(TokenizedDocument tDoc, String field) {
        this.field = field;
        this.iter = tDoc.getField(field).iterator(TokenVectorIterator.Mode.SUMMARY);
        this.endPos = Integer.MAX_VALUE;
        if (field.equals("_plain")) {
            this.endPos = SUPAUtils.getEndPlainTextPos(tDoc.getDocument(), new Vint8.Position());
        }
        this.lineInfo = new ArrayList<EOLInfo>();
        this.moreLines = this.next();
        this.lock = new ReentrantReadWriteLock();
        this.sBuf = new StringBuilder();
    }

    private boolean next() {
        return this.iter.next() && this.iter.getPosition() < this.endPos;
    }

    public boolean fullyLoaded() {
        return !this.moreLines;
    }

    public int numLines() {
        return this.lineInfo.size();
    }

    public String getField() {
        return this.field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLines(int start, int end, boolean codeStyle, boolean forwardDirection) {
        if (end > this.lineInfo.size() && this.moreLines) {
            this.loadLines(end);
        }
        this.lock.readLock().lock();
        try {
            int length = Math.max(0, Math.min(this.lineInfo.size() - start, end - start));
            if (codeStyle) {
                String[] stringArray = this.getCodeLines(start, length);
                return stringArray;
            }
            if (forwardDirection) {
                String[] stringArray = this.getForwardLines(start, length);
                return stringArray;
            }
            String[] stringArray = this.getBackwardLines(end, length);
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean isNonBlankLine(String str) {
        return str.length() != 1;
    }

    private String[] getBackwardLines(int end, int numNonBlankLinesToLoad) {
        LinkedList<String> results = new LinkedList<String>();
        int numNonBlankLines = 0;
        for (int i = end - 1; numNonBlankLines < numNonBlankLinesToLoad && i > 0; --i) {
            EOLInfo next = this.lineInfo.get(i);
            EOLInfo curr = this.lineInfo.get(i - 1);
            results.addFirst(this.sBuf.substring(curr.offset, next.offset));
            if (!this.isNonBlankLine((String)results.getFirst())) continue;
            ++numNonBlankLines;
        }
        if (numNonBlankLines < numNonBlankLinesToLoad) {
            results.addFirst(this.getFirstLine());
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getForwardLines(int start, int numNonBlankLinesToLoad) {
        LinkedList<String> results = new LinkedList<String>();
        int offset = 0;
        int numNonBlankLines = 0;
        if (start == 0) {
            results.add(this.getFirstLine());
            if (this.isNonBlankLine((String)results.getFirst())) {
                ++numNonBlankLines;
            }
            offset = 1;
        }
        int i = start - 1 + offset;
        EOLInfo curr = this.lineInfo.get(i);
        while (numNonBlankLines < numNonBlankLinesToLoad) {
            if (i + 1 == this.lineInfo.size()) {
                if (this.moreLines) {
                    this.lock.readLock().unlock();
                    this.loadLines(this.lineInfo.size() + 5);
                    this.lock.readLock().lock();
                }
                if (i + 1 == this.lineInfo.size()) {
                    results.addLast(this.subString(curr.offset, this.lineInfo.size()));
                    break;
                }
            }
            EOLInfo next = this.lineInfo.get(i + 1);
            results.addLast(this.sBuf.substring(curr.offset, next.offset));
            if (this.isNonBlankLine((String)results.getLast())) {
                ++numNonBlankLines;
            }
            curr = next;
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getCodeLines(int start, int numLines) {
        String[] result = new String[numLines];
        int offset = 0;
        if (start == 0) {
            result[0] = this.getFirstLine();
            offset = 1;
        }
        int base = start - 1;
        EOLInfo curr = this.lineInfo.get(base + offset);
        for (int i = offset; i < numLines - 1; ++i) {
            EOLInfo next = this.lineInfo.get(base + i + 1);
            result[i] = this.sBuf.substring(curr.offset, next.offset);
            curr = next;
        }
        result[numLines - 1] = this.subString(curr.offset, base + numLines);
        return result;
    }

    private String subString(int startOffset, int endLineIndex) {
        if (endLineIndex < this.lineInfo.size()) {
            return this.sBuf.substring(startOffset, this.lineInfo.get((int)endLineIndex).offset);
        }
        return this.sBuf.substring(startOffset);
    }

    private String getFirstLine() {
        return this.sBuf.substring(0, this.lineInfo.get((int)0).offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineIndex(int pos) {
        if (this.needLoading(pos)) {
            this.loadLinesToPos(pos);
        }
        this.lock.readLock().lock();
        try {
            if (this.notEnoughLines(pos)) {
                int n = -1;
                return n;
            }
            int low = 0;
            int high = this.lineInfo.size();
            while (low != high) {
                int mid = (low + high) / 2;
                EOLInfo info = this.lineInfo.get(mid);
                if (info.position < pos) {
                    low = mid + 1;
                    continue;
                }
                high = mid;
            }
            int n = low;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean needLoading(int pos) {
        return this.moreLines && this.notEnoughLines(pos);
    }

    private boolean notEnoughLines(int pos) {
        return this.lineInfo.isEmpty() || this.lineInfo.get((int)(this.lineInfo.size() - 1)).position < pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLines(int end) {
        this.lock.writeLock().lock();
        try {
            while (this.moreLines && this.lineInfo.size() < end) {
                this.handleCurrentPosition();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLinesToPos(int pos) {
        this.lock.writeLock().lock();
        try {
            while (this.needLoading(pos)) {
                this.handleCurrentPosition();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void handleCurrentPosition() {
        if (this.iter.getType() == TToken.Type.SENTENCE) {
            EOLInfo info = new EOLInfo();
            info.offset = this.sBuf.length();
            info.position = this.iter.getPosition();
            this.lineInfo.add(info);
        } else {
            this.sBuf.append(this.iter);
        }
        this.moreLines = this.next();
    }

    private static class EOLInfo {
        int offset;
        int position;

        private EOLInfo() {
        }
    }
}

