/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.demo.linker.index;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.config.GlobalConfig;
import com.ibm.supa.demo.linker.UnstructuredDocumentsExtractor;
import com.ibm.supa.search.SearchWrapper;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnstructuredDocumentsExtractorForSupa
implements UnstructuredDocumentsExtractor {
    @Override
    public Collection<TokenizedDocument> execute(String collectionID) throws Exception {
        return this.execute(collectionID, null);
    }

    @Override
    public Collection<TokenizedDocument> execute(String collectionID, Query filterQuery) throws SiapiException, IOException, ExtendedException {
        LinkedList<TokenizedDocument> result = new LinkedList<TokenizedDocument>();
        SearchWrapper Search_Wrapper = new SearchWrapper(collectionID, null);
        TermQuery docQuery = new TermQuery(new Term("structured", "false"));
        if (filterQuery != null) {
            BooleanQuery combinedQuery = new BooleanQuery();
            combinedQuery.add((Query)docQuery, BooleanClause.Occur.MUST);
            combinedQuery.add(filterQuery, BooleanClause.Occur.MUST);
            docQuery = combinedQuery;
        }
        BitSet bit_set = new QueryWrapperFilter((Query)docQuery).bits(Search_Wrapper.getTextIndexReader());
        GlobalConfig config = ConfigurationLoader.getGlobalConfig();
        int document_index = bit_set.nextSetBit(0);
        while (document_index >= 0) {
            TokenizedDocument tDoc = config.getDocumentCache().load(Search_Wrapper, document_index);
            result.add(tDoc);
            document_index = bit_set.nextSetBit(document_index + 1);
        }
        return result;
    }
}

