/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.demo.linker.index;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexerListener;
import com.ibm.es.nuvo.indexer.DocumentIndexerListenerInterface;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.demo.linker.UnstructuredDocumentsExtractor;
import com.ibm.supa.demo.linker.index.Section;
import com.ibm.supa.demo.linker.index.SectionBuilder;
import com.ibm.supa.demo.linker.index.UnstructuredDocumentsExtractorForSupa;
import com.ibm.supa.linker.util.DirectoryManager;
import com.ibm.supa.search.SearchWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.LockObtainFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkerIndexer
extends DocumentIndexerListener {
    private final ExecutorService execService = SUPAUtils.newDaemonExecutor();
    private final Map<String, CollectionIndexer> collectionIndexers = new ConcurrentHashMap<String, CollectionIndexer>();

    @Override
    public void documentOperationSuccessful(String collectionId, BaseDocument document, DocumentIndexerListenerInterface.OperationType operation) {
        this.addTask(collectionId, document.getUri());
    }

    private void addTask(String collectionId, String uri) {
        this.getCollectionIndexer(collectionId).add(uri);
    }

    private void addTasks(String collectionId, Collection<String> uris) {
        CollectionIndexer idx = this.getCollectionIndexer(collectionId);
        for (String uri : uris) {
            idx.add(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionIndexer getCollectionIndexer(String collectionId) {
        CollectionIndexer idx = this.collectionIndexers.get(collectionId);
        if (idx == null) {
            Map<String, CollectionIndexer> map = this.collectionIndexers;
            synchronized (map) {
                idx = this.collectionIndexers.get(collectionId);
                if (idx == null) {
                    idx = new CollectionIndexer(collectionId);
                    this.collectionIndexers.put(collectionId, idx);
                }
            }
        }
        return idx;
    }

    @Override
    public void indexClosed(String collectionId) {
        CollectionIndexer idx = this.collectionIndexers.get(collectionId);
        if (idx != null) {
            idx.executeWaiting();
        }
    }

    @Override
    public void indexQuiesced(String collectionId) {
        this.indexClosed(collectionId);
    }

    @Override
    public void indexUpdated(String collectionId) {
        this.update(collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String collectionId) {
        DirectoryManager.clearOrMakeAnEmptyIndexFolder(collectionId);
        try {
            SearchWrapper wrapper = new SearchWrapper(collectionId, null);
            IndexReader reader = wrapper.getTextIndexReader();
            MapFieldSelector selector = new MapFieldSelector(new String[]{"uri"});
            ArrayList<String> uris = new ArrayList<String>();
            try {
                TermDocs termDocs = reader.termDocs(new Term("structured", "false"));
                try {
                    while (termDocs.next()) {
                        uris.add(reader.document(termDocs.doc(), (FieldSelector)selector).get("uri"));
                    }
                }
                finally {
                    termDocs.close();
                }
            }
            finally {
                wrapper.close();
            }
            this.addTasks(collectionId, uris);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestUpdate(final String collectionId) {
        this.execService.submit(new Runnable(){

            public void run() {
                LinkerIndexer.this.update(collectionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String collectionId) {
        Set<String> linkUris = Collections.emptySet();
        Set linkHashes = Collections.emptySet();
        if (DirectoryManager.indexExists(collectionId)) {
            try {
                IndexReader reader = IndexReader.open((String)DirectoryManager.collectionToIndexPath(collectionId));
                try {
                    linkUris = new HashSet();
                    linkHashes = new HashSet();
                    MapFieldSelector selector = new MapFieldSelector(new String[]{"lookup_uri", "lookup__dochash"});
                    TermDocs termDocs = reader.termDocs(new Term("lookup", "lookup"));
                    try {
                        while (termDocs.next()) {
                            if (reader.isDeleted(termDocs.doc())) continue;
                            Document doc = reader.document(termDocs.doc(), (FieldSelector)selector);
                            String uri = doc.get("lookup_uri");
                            linkUris.add(uri);
                            linkHashes.add(uri + doc.get("lookup__dochash"));
                        }
                    }
                    finally {
                        termDocs.close();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Continuing...");
            }
        }
        Set<String> urisToIndex = Collections.emptySet();
        try {
            SearchWrapper wrapper = new SearchWrapper(collectionId, null);
            IndexReader reader = wrapper.getTextIndexReader();
            MapFieldSelector selector = new MapFieldSelector(new String[]{"uri"});
            try {
                HashSet<String> indexedUris = new HashSet<String>();
                TermDocs termDocs = reader.termDocs(new Term("structured", "false"));
                try {
                    while (termDocs.next()) {
                        if (reader.isDeleted(termDocs.doc())) continue;
                        indexedUris.add(reader.document(termDocs.doc(), (FieldSelector)selector).get("uri"));
                    }
                }
                finally {
                    termDocs.close();
                }
                urisToIndex = new HashSet<String>(indexedUris);
                urisToIndex.removeAll(linkUris);
                linkUris.removeAll(indexedUris);
                long[] hashes = wrapper.getDocHashes();
                termDocs = reader.termDocs(new Term("structured", "false"));
                try {
                    while (termDocs.next()) {
                        String uri;
                        int docNum = termDocs.doc();
                        if (reader.isDeleted(docNum) || linkHashes.remove((uri = reader.document(docNum, (FieldSelector)selector).get("uri")) + hashes[docNum])) continue;
                        urisToIndex.add(uri);
                    }
                }
                finally {
                    termDocs.close();
                }
            }
            finally {
                wrapper.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Continuing...");
        }
        this.getCollectionIndexer(collectionId).clearDocs(linkUris);
        if (urisToIndex.isEmpty()) {
            System.out.println("Linker index is already updated for collection " + collectionId);
        } else {
            this.addTasks(collectionId, urisToIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionIndexer {
        private final String collectionId;
        private final AtomicLong taskCounter;
        private final Map<String, AddTask> outstanding;
        private final ReentrantReadWriteLock lock;
        private final UnstructuredDocumentsExtractor extractor;
        private Set<AddTask> waiting;
        private IndexWriter writer;
        private SearchWrapper wrapper;

        public CollectionIndexer(String collectionId) {
            this.collectionId = collectionId;
            this.taskCounter = new AtomicLong();
            this.outstanding = Collections.synchronizedMap(new HashMap());
            this.lock = new ReentrantReadWriteLock();
            this.extractor = new UnstructuredDocumentsExtractorForSupa();
            this.createNewWaitingSet();
        }

        private void createNewWaitingSet() {
            this.waiting = Collections.synchronizedSet(new TreeSet());
        }

        private void add(String uri) {
            this.add(new AddTask(uri));
        }

        private void add(AddTask addTask) {
            Set<AddTask> w;
            do {
                w = this.waiting;
                w.add(addTask);
            } while (w != this.waiting && w.contains(addTask));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeWaiting() {
            Set<AddTask> old = this.waiting;
            this.createNewWaitingSet();
            Set<AddTask> set = old;
            synchronized (set) {
                for (AddTask task : old) {
                    if (task == null) continue;
                    if (this.outstanding.containsKey(task.uri)) {
                        this.add(task);
                        continue;
                    }
                    this.outstanding.put(task.uri, task);
                    LinkerIndexer.this.execService.submit(task);
                }
                old.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
            this.lock.writeLock().lock();
            try {
                if (this.writer == null) {
                    this.writer = new IndexWriter(DirectoryManager.collectionToIndexPath(this.collectionId), (Analyzer)new StopAnalyzer(new File(DirectoryManager.COMMON_WORDS)));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initWrapper() throws SiapiException {
            this.lock.writeLock().lock();
            try {
                if (this.wrapper == null) {
                    this.wrapper = new SearchWrapper(this.collectionId, null);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeWriterAndWrapperIfPossible() {
            block10: {
                this.lock.writeLock().lock();
                try {
                    Object temp;
                    if (!this.outstanding.isEmpty() || !this.waiting.isEmpty() || this.writer == null && this.wrapper == null) break block10;
                    try {
                        temp = this.writer;
                        this.writer = null;
                        if (temp != null) {
                            temp.flush();
                            if (Math.sqrt(temp.docCount()) * Math.random() < 1.0) {
                                temp.optimize();
                            }
                            temp.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        temp = this.wrapper;
                        this.wrapper = null;
                        if (temp != null) {
                            ((SearchWrapper)temp).close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("Closed linker writer for collection " + this.collectionId);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearDocs(Collection<String> uris) {
            if (uris.isEmpty()) {
                return;
            }
            Term[] terms = new Term[2 * uris.size()];
            int i = 0;
            for (String uri : uris) {
                terms[i++] = new Term("uri", uri);
                terms[i++] = new Term("lookup_uri", uri);
            }
            this.lock.writeLock().lock();
            try {
                this.initWriter();
                this.writer.deleteDocuments(terms);
                this.closeWriterAndWrapperIfPossible();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AddTask
        implements Comparable<AddTask>,
        Runnable {
            final long taskNum;
            final String uri;

            public AddTask(String uri) {
                this.taskNum = CollectionIndexer.this.taskCounter.addAndGet(1L);
                this.uri = uri;
            }

            @Override
            public int compareTo(AddTask o) {
                return Long.signum(this.taskNum - o.taskNum);
            }

            @Override
            public void run() {
                this.completeDocOp();
                CollectionIndexer.this.outstanding.remove(this.uri);
                CollectionIndexer.this.closeWriterAndWrapperIfPossible();
            }

            private void completeDocOp() {
                try {
                    CollectionIndexer.this.initWriter();
                    assert (DirectoryManager.indexExists(CollectionIndexer.this.collectionId));
                    this.indexUnstructuredDocs();
                }
                catch (Exception e) {
                    if (GlobalSystem.getSingleInstance().isShutdownInProgress()) {
                        return;
                    }
                    e.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void indexUnstructuredDocs() throws Exception {
                Term uriTerm = new Term("uri", this.uri);
                TermQuery filterQuery = new TermQuery(uriTerm);
                Collection<TokenizedDocument> tokDocs = CollectionIndexer.this.extractor.execute(CollectionIndexer.this.collectionId, (Query)filterQuery);
                if (tokDocs.isEmpty()) {
                    return;
                }
                assert (tokDocs.size() == 1);
                Collection<Section> sections = new SectionBuilder(tokDocs).buildSections();
                tokDocs = null;
                CollectionIndexer.this.lock.writeLock().lock();
                try {
                    CollectionIndexer.this.initWriter();
                    CollectionIndexer.this.writer.deleteDocuments(new Term[]{new Term("uri", this.uri), new Term("lookup_uri", this.uri)});
                    for (Section section : sections) {
                        Document document = new Document();
                        if (!section.getUri().equals(this.uri)) {
                            System.err.println(section.getUri());
                            System.err.println(this.uri);
                        }
                        document.add((Fieldable)new Field("uri", section.getUri(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                        String start_position = new Integer(section.getStart_position()).toString();
                        document.add((Fieldable)new Field("start_position", start_position, Field.Store.YES, Field.Index.NO));
                        String last_position = new Integer(section.getLast_position()).toString();
                        document.add((Fieldable)new Field("end_position", last_position, Field.Store.YES, Field.Index.NO));
                        String content = section.getSection_content().toString();
                        document.add((Fieldable)new Field("_plain", content, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.YES));
                        CollectionIndexer.this.writer.addDocument(document);
                    }
                    CollectionIndexer.this.initWrapper();
                    TermDocs termDocs = CollectionIndexer.this.wrapper.getTextIndexReader().termDocs(uriTerm);
                    try {
                        while (termDocs.next()) {
                            int docNum = termDocs.doc();
                            long hash = CollectionIndexer.this.wrapper.getDocHashes()[docNum];
                            Document document = new Document();
                            document.add((Fieldable)new Field("lookup", "lookup", Field.Store.YES, Field.Index.UN_TOKENIZED));
                            document.add((Fieldable)new Field("lookup_uri", this.uri, Field.Store.YES, Field.Index.UN_TOKENIZED));
                            document.add((Fieldable)new Field("lookup__dochash", String.valueOf(hash), Field.Store.YES, Field.Index.UN_TOKENIZED));
                            CollectionIndexer.this.writer.addDocument(document);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        termDocs.close();
                    }
                }
                finally {
                    CollectionIndexer.this.lock.writeLock().unlock();
                }
            }
        }
    }
}

