/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.config;

import com.ibm.supa.config.ClassLoaderConfig;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalURLClassLoader
implements ClassLoaderConfig {
    private String[] relativePaths;

    public void setRelativePaths(String[] relativePaths) {
        this.relativePaths = relativePaths;
    }

    public void setRelativePaths(List<String> relativePaths) {
        this.relativePaths = relativePaths.toArray(new String[relativePaths.size()]);
    }

    @Override
    public ClassLoader createClassLoader(String baseDirPath, ClassLoader parent) {
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        if (this.relativePaths == null || this.relativePaths.length == 0) {
            return parent;
        }
        try {
            URL[] urls = new URL[this.relativePaths.length];
            int i = 0;
            for (String path : this.relativePaths) {
                urls[i++] = new File(baseDirPath, path).toURL();
            }
            return new URLClassLoader(urls, parent);
        }
        catch (Exception e) {
            System.err.print("Problem loading class-loader. Using parent/default instead. Exception was: ");
            e.printStackTrace();
            return parent;
        }
    }
}

