/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.config;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ClassLoaderConfig;
import com.ibm.supa.config.GlobalConfig;
import com.ibm.supa.config.springUtils.ThreadScope;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationLoader {
    private static final String SUPA_DIRECTORY_NAME = "supa";
    private static final String ANALYSIS_SCOPE_FILENAME = "analysis-scope.xml";
    private static final String GLOBAL_CONFIG_FILENAME = "global-config.xml";
    private static final String CLASS_LOADER_FILENAME = "class-loader-config.xml";
    private static Map<String, ApplicationContext> CACHE = new ConcurrentHashMap<String, ApplicationContext>();
    private static Map<ApplicationContext, String> REVERSE_CACHE = new ConcurrentHashMap<ApplicationContext, String>();
    static final String MISSING_INTERCEPT = "Missing intercept in Spring configuration file";

    public static String getSupaDirectoryPath(String collectionId) {
        String result = CollectionConfiguration.buildCollectionPath(collectionId);
        if (result != null) {
            result = ConfigurationLoader.getSupaSubDirPath(result);
        }
        return result;
    }

    public static String getSupaDirectoryPath() {
        String result = GlobalConfiguration.getConfiguration().getConfigPath();
        if (result != null) {
            result = ConfigurationLoader.getSupaSubDirPath(result);
        }
        return result;
    }

    private static String getSupaSubDirPath(String baseDirPath) {
        String path;
        try {
            path = new File(baseDirPath, SUPA_DIRECTORY_NAME).getCanonicalPath();
        }
        catch (IOException e) {
            path = new File(baseDirPath, SUPA_DIRECTORY_NAME).getAbsolutePath();
        }
        return path;
    }

    private static String getSupaFilePath(String collectionId, String fileName) {
        String path;
        try {
            path = new File(ConfigurationLoader.getSupaDirectoryPath(collectionId), fileName).getCanonicalPath();
        }
        catch (IOException e) {
            path = new File(ConfigurationLoader.getSupaDirectoryPath(collectionId), fileName).getAbsolutePath();
        }
        return path;
    }

    private static String getSupaFilePath(String fileName) {
        String path;
        try {
            path = new File(ConfigurationLoader.getSupaDirectoryPath(), fileName).getCanonicalPath();
        }
        catch (IOException e) {
            path = new File(ConfigurationLoader.getSupaDirectoryPath(), fileName).getAbsolutePath();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationContext getAppContext(String filePath, String classLoaderPath, String baseClassLoaderPath, boolean addGlobalClassLoader) {
        ApplicationContext result = CACHE.get(filePath);
        if (result == null) {
            String string = filePath = filePath.intern();
            synchronized (string) {
                result = CACHE.get(filePath);
                if (result == null) {
                    try {
                        ClassLoader loader;
                        ClassLoader newLoader = loader = ConfigurationLoader.class.getClassLoader();
                        ClassLoader parent = null;
                        if (addGlobalClassLoader) {
                            String globalFilePath = ConfigurationLoader.getSupaFilePath(GLOBAL_CONFIG_FILENAME);
                            ApplicationContext globalContext = CACHE.get(globalFilePath);
                            if (globalContext == null) {
                                ConfigurationLoader.getGlobalConfig();
                                globalContext = CACHE.get(globalFilePath);
                            }
                            if (globalContext != null) {
                                parent = globalContext.getClassLoader();
                            }
                        }
                        if (classLoaderPath != null && new File(classLoaderPath).exists()) {
                            try {
                                FileSystemXmlApplicationContext clCtx = ConfigurationLoader.createFileSystemXMLAppContext(classLoaderPath);
                                newLoader = ConfigurationLoader.getBean((BeanFactory)clCtx, ClassLoaderConfig.class).createClassLoader(baseClassLoaderPath, parent);
                            }
                            catch (RuntimeException e) {
                                System.err.println("Error loading class-loader, problems may occur. Exception is:");
                                e.printStackTrace();
                            }
                        }
                        if (newLoader == loader && parent != null) {
                            newLoader = parent;
                        }
                        FileSystemXmlApplicationContext ctx = null;
                        if (newLoader != loader) {
                            try {
                                Thread currentThread = Thread.currentThread();
                                loader = currentThread.getContextClassLoader();
                                if (newLoader != loader) {
                                    currentThread.setContextClassLoader(newLoader);
                                    ctx = ConfigurationLoader.createFileSystemXMLAppContext(filePath);
                                    currentThread.setContextClassLoader(loader);
                                }
                            }
                            catch (SecurityException e) {
                                try {
                                    Class[] paramTypes = new Class[]{String.class};
                                    Class<?> clazz = newLoader.loadClass(FileSystemXmlApplicationContext.class.getName());
                                    Constructor<?> cons = clazz.getConstructor(paramTypes);
                                    ctx = (FileSystemXmlApplicationContext)cons.newInstance(filePath);
                                }
                                catch (Exception ex) {
                                    System.err.println("Unable to load class-loader, exception was: ");
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if (ctx == null) {
                            ctx = ConfigurationLoader.createFileSystemXMLAppContext(filePath);
                        }
                        ctx.setClassLoader(newLoader);
                        ctx.refresh();
                        ctx.getBeanFactory().registerScope("thread", (Scope)new ThreadScope());
                        result = ctx;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    CACHE.put(filePath, result);
                    REVERSE_CACHE.put(result, filePath);
                }
            }
        }
        return result;
    }

    private static FileSystemXmlApplicationContext createFileSystemXMLAppContext(String filePath) {
        return new FileSystemXmlApplicationContext("file:" + filePath);
    }

    private static ApplicationContext removeAppContext(String filePath) {
        ApplicationContext result = CACHE.remove(filePath);
        if (result != null) {
            REVERSE_CACHE.remove(result);
        }
        return result;
    }

    protected static <E> E getBean(BeanFactory factory, Class<E> clazz) {
        E result = ConfigurationLoader.getBean(factory, clazz, clazz.getSimpleName());
        if (result == null) {
            result = ConfigurationLoader.getBean(factory, clazz, clazz.getName());
        }
        return result;
    }

    protected static <E> E getBean(BeanFactory factory, Class<E> clazz, String name) {
        return clazz.cast(factory.getBean(name, clazz));
    }

    public static String getFilePath(ApplicationContext ctx) {
        return REVERSE_CACHE.get(ctx);
    }

    public static AnalysisScopeConfig getAnalysisScopeConfig(String collectionId) {
        String supaFilePath = ConfigurationLoader.getSupaFilePath(collectionId, ANALYSIS_SCOPE_FILENAME);
        String classLoaderPath = ConfigurationLoader.getSupaFilePath(collectionId, CLASS_LOADER_FILENAME);
        String baseDirPath = ConfigurationLoader.getSupaDirectoryPath(collectionId);
        return ConfigurationLoader.getBean((BeanFactory)ConfigurationLoader.getAppContext(supaFilePath, classLoaderPath, baseDirPath, true), AnalysisScopeConfig.class);
    }

    public static GlobalConfig getGlobalConfig() {
        String supaFilePath = ConfigurationLoader.getSupaFilePath(GLOBAL_CONFIG_FILENAME);
        String classLoaderPath = ConfigurationLoader.getSupaFilePath(CLASS_LOADER_FILENAME);
        String baseDirPath = ConfigurationLoader.getSupaDirectoryPath();
        return ConfigurationLoader.getBean((BeanFactory)ConfigurationLoader.getAppContext(supaFilePath, classLoaderPath, baseDirPath, false), GlobalConfig.class);
    }

    public static void createDefaultAnalysisScopeConfig(String collectionId) {
        String defaultSupaDirPath = GlobalConfiguration.getConfiguration().getConfigFileName("defaults", SUPA_DIRECTORY_NAME);
        File defaultSupaDir = new File(defaultSupaDirPath);
        File targetSupaDir = new File(ConfigurationLoader.getSupaDirectoryPath(collectionId));
        try {
            FileUtils.copyDirectory((File)defaultSupaDir, (File)targetSupaDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean unloadAnalysisScopeConfig(String collectionId) {
        return ConfigurationLoader.removeAppContext(ConfigurationLoader.getSupaFilePath(collectionId, ANALYSIS_SCOPE_FILENAME)) != null;
    }

    public static boolean unloadGlobalConfig() {
        return ConfigurationLoader.removeAppContext(ConfigurationLoader.getSupaFilePath(GLOBAL_CONFIG_FILENAME)) != null;
    }
}

