/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.common.text;

import java.util.Comparator;

public class TextUtils {
    public static Comparator<CharSequence> LEX_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int length = Math.min(o1.length(), o2.length());
            for (int i = 0; i < length; ++i) {
                int result = o1.charAt(i) - o2.charAt(i);
                if (result == 0) continue;
                return result;
            }
            return o1.length() - o2.length();
        }
    };
    public static Comparator<CharSequence> LEX_CASE_INSENSITIVE_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int length = Math.min(o1.length(), o2.length());
            for (int i = 0; i < length; ++i) {
                int result = TextUtils.makeInsensitive(o1.charAt(i)) - TextUtils.makeInsensitive(o2.charAt(i));
                if (result == 0) continue;
                return result;
            }
            return o1.length() - o2.length();
        }
    };

    public static char makeInsensitive(char ch) {
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public static int getMatchLength(CharSequence o1, CharSequence o2, boolean caseSensitive) {
        int length = Math.min(o1.length(), o2.length());
        for (int i = 0; i < length; ++i) {
            char c1 = o1.charAt(i);
            char c2 = o2.charAt(i);
            if (!caseSensitive) {
                c1 = TextUtils.makeInsensitive(c1);
                c2 = TextUtils.makeInsensitive(c2);
            }
            if (c1 == c2) continue;
            return i;
        }
        return length;
    }

    public static CharSequence slashUnescape(CharSequence seq) {
        StringBuilder sBuf = null;
        boolean escaped = false;
        for (int i = 0; i < seq.length(); ++i) {
            char ch = seq.charAt(i);
            if (escaped) {
                sBuf.append(ch);
                escaped = false;
                continue;
            }
            if (ch == '\\') {
                if (sBuf == null) {
                    sBuf = new StringBuilder();
                    for (int j = 0; j < i; ++j) {
                        sBuf.append(seq.charAt(j));
                    }
                }
                escaped = true;
                continue;
            }
            if (sBuf == null) continue;
            sBuf.append(ch);
        }
        return sBuf != null ? sBuf.toString() : seq;
    }
}

