/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.common.text;

import java.text.CharacterIterator;

public class CharSequenceIterator
implements CharacterIterator {
    private final CharSequence sequence;
    private int index;

    public CharSequenceIterator(CharSequence charSequence) {
        this.sequence = charSequence;
        this.index = 0;
    }

    public char current() {
        if (this.index == this.sequence.length()) {
            return '\uffff';
        }
        return this.sequence.charAt(this.index);
    }

    public char first() {
        this.index = this.getBeginIndex();
        return this.current();
    }

    public char last() {
        this.index = this.getEndIndex();
        if (this.index != 0) {
            --this.index;
        }
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.sequence.length();
    }

    public int getIndex() {
        return this.index;
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException("Illegal position (valid range [" + this.getBeginIndex() + "," + this.getEndIndex() + "]: " + position);
        }
        this.index = position;
        return this.current();
    }

    public char next() {
        if (this.index == this.getEndIndex()) {
            return '\uffff';
        }
        ++this.index;
        return this.current();
    }

    public char previous() {
        if (this.index == this.getBeginIndex()) {
            return '\uffff';
        }
        --this.index;
        return this.current();
    }

    public Object clone() {
        CharSequenceIterator result = new CharSequenceIterator(this.sequence);
        result.index = this.index;
        return result;
    }
}

