/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.common;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.siapi.SiapiException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.document.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUPAUtils {
    public static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setDaemon(true);
            return result;
        }
    };

    public static <T> ThreadLocal<T> createThreadLocal(final Class clazz) {
        return new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                try {
                    return clazz.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    public static <E> E completeTask(FutureTask<E> task) throws ExtendedException, IOException, SiapiException {
        if (task == null) {
            return null;
        }
        while (!GlobalSystem.getSingleInstance().isShutdownInProgress()) {
            try {
                return task.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof ExtendedException) {
                    throw (ExtendedException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof SiapiException) {
                    throw (SiapiException)t;
                }
                throw new RuntimeException(t);
            }
        }
        return null;
    }

    public static <E> E[] completeTasks(FutureTask<E>[] tasks, Class<E> clazz) throws ExtendedException, IOException, SiapiException {
        Object[] result = (Object[])Array.newInstance(clazz, tasks.length);
        for (int i = 0; i < tasks.length; ++i) {
            result[i] = SUPAUtils.completeTask(tasks[i]);
        }
        return result;
    }

    public static ExecutorService newDaemonExecutor() {
        return SUPAUtils.newDaemonExecutor(Runtime.getRuntime().availableProcessors());
    }

    public static ExecutorService newDaemonExecutor(int numThreads) {
        return Executors.newFixedThreadPool(numThreads, DAEMON_THREAD_FACTORY);
    }

    public static int getEndPlainTextPos(Document doc, Vint8.Position pos) {
        return SUPAUtils.readVInt8Field(doc, "_plainendpos", Integer.MAX_VALUE, pos);
    }

    public static boolean isStructured(Document doc) {
        String value = doc.get("structured");
        return value == null ? true : Boolean.valueOf(value);
    }

    public static int readVInt8Field(Document doc, String field, int defaultValue, Vint8.Position pos) {
        byte[] bytes = doc.getBinaryValue(field);
        if (bytes == null) {
            return defaultValue;
        }
        pos.pos = 0;
        return Vint8.decode(bytes, pos);
    }

    public static String[] getCollectionIds(String index) {
        String[] result;
        if ("\tAll".equals(index)) {
            ConfigurationManager cfgManager = ConfigurationManager.getConfigurationManager();
            Vector<String> collectionIds = cfgManager.getCollectionIds();
            return collectionIds.toArray(new String[collectionIds.size()]);
        }
        if (index != null) {
            StringTokenizer sTok = new StringTokenizer(index, "\n");
            result = new String[sTok.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = sTok.nextToken();
            }
        } else {
            result = new String[]{};
        }
        return result;
    }
}

