/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.Shutdown;
import com.ibm.es.nuvo.Startup;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationObjectCreateException;
import com.ibm.es.nuvo.configuration.tool.ConfigurationTool;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.OptimizeIndexDocument;
import com.ibm.es.nuvo.documentqueue.UpdateIndexDocument;
import com.ibm.es.nuvo.httplistener.HttpListenerConfigurationTool;
import com.ibm.supa.linker.util.DirectoryManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;

public class Console {
    private static final String DEFAULT_PATH = "package" + File.separator + "config" + File.separator;
    private static final String CONFIG_FILE_PATH = "config.xml";
    private static final String COLLECTIONS_DIR = "collections";
    private static final String TEXT_INDEX_PATH = "data/text";
    private static final String DEFAULT_COLLECTION_NAME = "default";
    private String path = DEFAULT_PATH;
    private boolean started = false;

    private void printMenu() {
        System.out.println();
        System.out.print("Commands are: setpath [path], start, faststop, stop, cleanall, clean [collection], optimizeall, optimize [collection], optimizepath");
        if (this.started) {
            System.out.print(" , rebuild [collection], create [collection], clear [collection]");
        }
        System.out.println("setdefports, configure, confports, help, exit");
        System.out.println();
    }

    private static String readCommand(BufferedReader in) throws IOException {
        System.out.print("Command: ");
        return in.readLine();
    }

    private void configure(BufferedReader in) throws IOException {
        ConfigurationTool configTool = new ConfigurationTool(this.getArgs(in));
        configTool.configure();
    }

    private void confPorts(BufferedReader in) throws IOException {
        HttpListenerConfigurationTool.main(this.getArgs(in));
    }

    private void setDefaultPorts() {
        String[] args = new String[]{"-globalConfig", this.getConfigFilePath(), "-hostName", "0.0.0.0", "-adminHttp", "8888", "-searchHttp", "8888", "-adminHttps", "8443", "-searchHttps", "8443"};
        HttpListenerConfigurationTool.main(args);
    }

    private String[] getArgs(BufferedReader in) throws IOException {
        System.out.print("Enter args: ");
        String prev = null;
        ArrayList<String> argList = new ArrayList<String>();
        StringTokenizer stok = new StringTokenizer(in.readLine());
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (prev != null && prev.startsWith("\"") && !prev.endsWith("\"")) {
                argList.set(argList.size() - 1, prev + token);
            } else {
                argList.add(token);
            }
            prev = (String)argList.get(argList.size() - 1);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        return args;
    }

    private void updatePath(String line, String cmd, StringTokenizer sTok) {
        this.path = DEFAULT_PATH;
        if (sTok.hasMoreTokens()) {
            this.path = line.substring(cmd.length()).trim();
            if (!this.path.endsWith(File.separator)) {
                this.path = this.path + File.separator;
            }
        }
    }

    private String getCollectionName(String line, String cmd, StringTokenizer sTok) {
        String result = DEFAULT_COLLECTION_NAME;
        if (sTok.hasMoreTokens()) {
            result = line.substring(cmd.length()).trim();
        }
        return result;
    }

    private String getConfigFilePath() {
        return this.path + CONFIG_FILE_PATH;
    }

    private void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Welcome to SUPA OmniFind Express Edition!");
        this.printMenu();
        while (true) {
            try {
                while (true) {
                    Object collectionsIds;
                    File allCollections;
                    File dir;
                    String line;
                    StringTokenizer sTok;
                    if (!(sTok = new StringTokenizer(line = Console.readCommand(in).trim())).hasMoreTokens()) {
                        continue;
                    }
                    String cmd = sTok.nextToken().toLowerCase();
                    if (cmd.equals("help")) {
                        this.printMenu();
                        continue;
                    }
                    if (cmd.equals("exit")) {
                        Console.exit();
                        continue;
                    }
                    if (cmd.equals("setpath")) {
                        this.updatePath(line, cmd, sTok);
                        continue;
                    }
                    if (cmd.equals("start")) {
                        this.startup();
                        continue;
                    }
                    if (cmd.equals("stop")) {
                        this.shutdown();
                        continue;
                    }
                    if (cmd.equals("faststop")) {
                        this.localShutdown();
                        Console.exit();
                        continue;
                    }
                    if (cmd.equals("configure")) {
                        this.configure(in);
                        continue;
                    }
                    if (cmd.equals("confports")) {
                        this.confPorts(in);
                        continue;
                    }
                    if (cmd.equals("setdefports")) {
                        this.setDefaultPorts();
                        continue;
                    }
                    if (cmd.equals("cleanall")) {
                        File[] files = new File(this.path, COLLECTIONS_DIR).listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (!file.isDirectory()) continue;
                                FileUtils.deleteDirectory((File)file);
                            }
                        }
                        System.out.println("Cleaned");
                        continue;
                    }
                    if (cmd.equals("clean")) {
                        dir = new File(this.path, COLLECTIONS_DIR);
                        File subDir = new File(dir, this.getCollectionName(line, cmd, sTok));
                        if (!subDir.exists()) {
                            System.out.println("Directory does not exist!");
                            continue;
                        }
                        FileUtils.deleteDirectory((File)subDir);
                        System.out.println("Cleaned");
                        continue;
                    }
                    if (cmd.equals("optimizeall")) {
                        File[] files;
                        dir = new File(this.path, COLLECTIONS_DIR);
                        for (File file : files = dir.listFiles()) {
                            if (!file.isDirectory()) continue;
                            System.out.print("Optimizing " + file.getName() + "... ");
                            this.optimize(file.getName());
                        }
                        System.out.println("All Optimized");
                        continue;
                    }
                    if (cmd.equals("optimize")) {
                        this.optimize(this.getCollectionName(line, cmd, sTok));
                        continue;
                    }
                    if (cmd.equals("optimizepath")) {
                        this.optimizePath(in);
                        continue;
                    }
                    if (this.started && cmd.equals("rebuild")) {
                        this.rebuild(this.getCollectionName(line, cmd, sTok));
                        continue;
                    }
                    if (this.started && cmd.equals("create")) {
                        Console.createCollection(this.getCollectionName(line, cmd, sTok));
                        continue;
                    }
                    if (this.started && cmd.equals("clear")) {
                        Console.clearCollection(this.getCollectionName(line, cmd, sTok));
                        continue;
                    }
                    if (this.started && cmd.equals("createlinkerindex")) {
                        String collectionId;
                        allCollections = new File(this.path, COLLECTIONS_DIR);
                        collectionsIds = Arrays.asList(allCollections.list());
                        if (!collectionsIds.contains(collectionId = this.getCollectionName(line, cmd, sTok))) {
                            System.out.println("collection - " + collectionId + " does not exist");
                            continue;
                        }
                        GlobalSystem.getSingleInstance().getLinkerIndexer().reset(collectionId);
                        continue;
                    }
                    if (this.started && cmd.equals("updatelinkerindex")) {
                        String collectionId;
                        allCollections = new File(this.path, COLLECTIONS_DIR);
                        collectionsIds = Arrays.asList(allCollections.list());
                        if (!collectionsIds.contains(collectionId = this.getCollectionName(line, cmd, sTok))) {
                            System.out.println("collection - " + collectionId + " does not exist");
                            continue;
                        }
                        GlobalSystem.getSingleInstance().getLinkerIndexer().update(collectionId);
                        continue;
                    }
                    if (this.started && cmd.equals("clearlinkerindices")) {
                        allCollections = new File(this.path, COLLECTIONS_DIR);
                        for (String collectionId : collectionsIds = allCollections.list()) {
                            DirectoryManager.clearOrMakeAnEmptyIndexFolder(collectionId);
                            System.out.println("Linker index is cleared for collection: " + collectionId);
                        }
                        System.out.println("Linker index is cleared for all collections");
                        continue;
                    }
                    this.printMenu();
                }
            }
            catch (Throwable t) {
                System.out.println("Exception occured!");
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void rebuild(String collectionName) throws InterruptedException {
        GlobalSystem.getSingleInstance().getIndexManager().rebuildCollection(collectionName);
    }

    public static void createCollection(String collectionId) throws ExtendedException {
        CollectionConfiguration config = CollectionConfiguration.createDefault();
        config.setId(collectionId);
        config.setEnabledForSearch(true);
        config.setIndexAllLemmasStr("true");
        try {
            ConfigurationManager.getConfigurationManager().createCollection(config);
        }
        catch (ConfigurationObjectCreateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void clearCollection(String collectionId) throws InterruptedException, ExtendedException, IOException {
        ConfigurationManager.getConfigurationManager().clearCollection(collectionId);
    }

    private void optimize(String collectionName) throws IOException, CorruptIndexException, LockObtainFailedException, DocumentQueueInsertException, InterruptedException {
        if (this.started) {
            DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
            OptimizeIndexDocument document = new OptimizeIndexDocument();
            docQueue.addDocument(collectionName, document);
            UpdateIndexDocument updateIndexDocument = new UpdateIndexDocument();
            docQueue.addDocument(collectionName, updateIndexDocument);
            while (docQueue.getCounter() > 0) {
                Thread.sleep(100L);
            }
            return;
        }
        File dir = new File(this.path, COLLECTIONS_DIR);
        File subDir = new File(dir, collectionName);
        this.optimize(new File(subDir, TEXT_INDEX_PATH));
    }

    private void optimizePath(BufferedReader in) throws CorruptIndexException, LockObtainFailedException, IOException {
        String[] args = this.getArgs(in);
        if (args == null || args.length == 0) {
            return;
        }
        this.optimize(new File(args[0]));
    }

    private void optimize(File directory) throws IOException, CorruptIndexException, LockObtainFailedException {
        if (!directory.exists()) {
            System.out.println("Directory does not exist!");
            return;
        }
        FSDirectory fsDir = FSDirectory.getDirectory((File)directory);
        new IndexWriter((Directory)fsDir, null).optimize();
        System.out.println("Optimized");
    }

    public void localShutdown() throws InterruptedException {
        System.out.println("Local shutdown started...");
        GlobalSystem.getSingleInstance().shutdown(false, true, null, Locale.getDefault(), false, true);
        System.out.println("Local shutdown complete.");
        this.started = false;
    }

    public void shutdown() {
        System.out.println("Shutting down...");
        Shutdown.main(new String[]{this.getConfigFilePath()});
        this.started = false;
    }

    public void startup() {
        Startup.main(new String[]{this.getConfigFilePath()});
        this.started = true;
    }

    private static void exit() {
        System.out.println("Exitting JVM");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        new Console().run();
    }
}

