/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.uri;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSURIUtil {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String URI_PREFIX = "file://";
    private static final String LOCALHOST = "localhost";
    private static final String SERVER_KEY = "serverKey";
    private static final String FILEPATH_KEY = "filepathKey";
    private static final String ARCHIVE_TAG = "?ArchiveEntry=";

    public static String encode(String decodedURI) {
        String entryName = null;
        if (decodedURI.contains(ARCHIVE_TAG)) {
            int startIndex = decodedURI.indexOf(ARCHIVE_TAG);
            int endIndex = startIndex + ARCHIVE_TAG.length();
            entryName = decodedURI.substring(endIndex);
            decodedURI = decodedURI.substring(0, startIndex);
        }
        int fromIndex = decodedURI.indexOf("://") + 3;
        decodedURI = decodedURI.substring(fromIndex);
        int toIndex = decodedURI.indexOf("/");
        decodedURI = decodedURI.substring(toIndex);
        File file = new File(decodedURI);
        if (File.separator.equals("\\")) {
            decodedURI = decodedURI.substring(1);
        }
        return FSURIUtil.createUri(null, file, true, entryName, decodedURI, null);
    }

    public static String decode(String encodedURI) {
        StringBuilder decodedURI = new StringBuilder(encodedURI.length());
        Map<String, String> map = FSURIUtil.doDecode(encodedURI);
        decodedURI.append(URI_PREFIX);
        decodedURI.append(map.get(SERVER_KEY));
        if (File.separator.equals("\\")) {
            decodedURI.append("/");
        }
        decodedURI.append(map.get(FILEPATH_KEY));
        return decodedURI.toString();
    }

    public static File getFileObject(String encodedURI) {
        Map<String, String> map = FSURIUtil.doDecode(encodedURI);
        String filePath = map.get(FILEPATH_KEY);
        return new File(filePath);
    }

    public static String getServerName(String encodedURI) {
        Map<String, String> map = FSURIUtil.doDecode(encodedURI);
        return map.get(SERVER_KEY);
    }

    private static Map<String, String> doDecode(String encodedURI) {
        String tmp;
        HashMap<String, String> map = new HashMap<String, String>();
        int fromIndex = encodedURI.indexOf("://") + 3;
        try {
            tmp = URLDecoder.decode(encodedURI.substring(fromIndex), DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            tmp = encodedURI.substring(fromIndex);
        }
        int toIndex = tmp.indexOf("/");
        String serverName = tmp.substring(0, toIndex);
        map.put(SERVER_KEY, serverName);
        tmp = tmp.substring(serverName.length());
        String filePath = new File(tmp).getAbsolutePath();
        if (File.separator.equals("\\")) {
            filePath = filePath.replaceAll("\\\\", "/");
        }
        map.put(FILEPATH_KEY, filePath);
        return map;
    }

    public static String getEncodedUri(String serverName, File file) {
        return FSURIUtil.createUri(serverName, file, true, null, null, null);
    }

    public static String getEncodedUri(String serverName, String parentPath, String fileName) {
        return FSURIUtil.createUri(serverName, null, true, null, parentPath, fileName);
    }

    public static String getDecodedUri(String serverName, File file) {
        return FSURIUtil.createUri(serverName, file, false, null, null, null);
    }

    private static String createUri(String serverNameArg, File file, boolean needEncoded, String entryName, String parentPathArg, String fileNameArg) {
        String path = null;
        String fileName = null;
        if (file != null) {
            if (file.isFile()) {
                path = file.getParent();
                fileName = file.getName();
            } else {
                fileName = null;
                path = file.getAbsolutePath();
            }
        } else if (parentPathArg != null) {
            path = parentPathArg;
            fileName = fileNameArg;
        } else {
            return "";
        }
        String newPath = null;
        newPath = File.separator.equals("\\") ? path.replaceAll("\\\\", "/") : path;
        StringBuilder buf = new StringBuilder(1024);
        buf.append(URI_PREFIX);
        if (serverNameArg != null) {
            buf.append(serverNameArg.toLowerCase());
        } else {
            buf.append(LOCALHOST);
        }
        if (newPath.equals("/")) {
            buf.append("/");
        } else {
            String[] dirNames = newPath.split("/");
            if (!dirNames[0].equals("")) {
                buf.append("/");
                buf.append(dirNames[0]);
            }
            for (int i = 1; i < dirNames.length; ++i) {
                buf.append("/");
                try {
                    if (needEncoded) {
                        buf.append(URLEncoder.encode(dirNames[i], DEFAULT_ENCODING));
                        continue;
                    }
                    buf.append(dirNames[i]);
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    buf.append(dirNames[i]);
                }
            }
        }
        buf.append("/");
        if (fileName != null) {
            try {
                buf.append(URLEncoder.encode(fileName, DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                buf.append(fileName);
            }
        }
        if (entryName != null) {
            buf.append(ARCHIVE_TAG);
            try {
                buf.append(URLEncoder.encode(entryName, DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                buf.append(entryName);
            }
        }
        return buf.toString().replaceAll("\\+", "%20");
    }
}

