/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.uri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseURIUtil {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final Pattern DELIMITER = Pattern.compile("[;/\\?:@&=$,]");
    private static final String ARCHIVE_KEY = "ArchiveEntry";

    public static String encode(String decodedURI) {
        if (decodedURI == null || decodedURI.length() == 0) {
            return decodedURI;
        }
        StringBuilder builder = new StringBuilder();
        try {
            String uri = BaseURIUtil.copyProtocol(decodedURI, builder);
            List<String> list = BaseURIUtil.tokenize(uri);
            boolean param = false;
            boolean archive = false;
            for (int i = 0; i < list.size(); ++i) {
                String part = list.get(i++);
                String delimiter = list.get(i);
                if (archive) {
                    builder.append(URLEncoder.encode(part, "utf-8"));
                    builder.append(URLEncoder.encode(delimiter, "utf-8"));
                } else {
                    if (!param) {
                        BaseURIUtil.encodePart(builder, part);
                    } else {
                        builder.append(part);
                    }
                    builder.append(delimiter);
                }
                if ("?".equals(delimiter)) {
                    param = true;
                    continue;
                }
                if (!param || !ARCHIVE_KEY.equals(part)) continue;
                archive = true;
            }
        }
        catch (Exception e) {
            return decodedURI;
        }
        return builder.toString();
    }

    private static void encodePart(StringBuilder builder, String part) {
        try {
            builder.append(URLEncoder.encode(part, "utf-8"));
        }
        catch (Exception ignored) {
            builder.append(part);
        }
    }

    public static String decode(String encodedURI) {
        if (encodedURI == null || encodedURI.length() == 0) {
            return encodedURI;
        }
        StringBuilder builder = new StringBuilder();
        try {
            String uri = BaseURIUtil.copyProtocol(encodedURI, builder);
            List<String> list = BaseURIUtil.tokenize(uri);
            boolean param = false;
            boolean archive = false;
            for (int i = 0; i < list.size(); ++i) {
                String part = list.get(i++);
                String delimiter = list.get(i);
                if (!param || archive) {
                    BaseURIUtil.decodePart(builder, part);
                    archive = false;
                } else {
                    builder.append(part);
                }
                builder.append(delimiter);
                if ("?".equals(delimiter)) {
                    param = true;
                    continue;
                }
                if (!param || !ARCHIVE_KEY.equals(part)) continue;
                archive = true;
            }
        }
        catch (Exception e) {
            return encodedURI;
        }
        return builder.toString();
    }

    private static List<String> tokenize(String encodedURI) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = DELIMITER.matcher(encodedURI);
        int i = 0;
        while (matcher.find()) {
            String part = encodedURI.substring(i, matcher.start());
            list.add(part == null ? "" : part);
            list.add(matcher.group());
            i = matcher.end();
        }
        if (i < encodedURI.length()) {
            list.add(encodedURI.substring(i));
            list.add("");
        }
        return list;
    }

    private static void decodePart(StringBuilder builder, String p) {
        if (BaseURIUtil.needDecode(p)) {
            builder.append(BaseURIUtil.decodeURI(p));
        } else {
            builder.append(p);
        }
    }

    private static String decodeURI(String part) {
        try {
            String verified = BaseURIUtil.verifyPart(part);
            return URLDecoder.decode(verified, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            ignored.printStackTrace();
            return part;
        }
    }

    private static String verifyPart(String part) {
        int i = 0;
        int j = 0;
        int l = part.length();
        StringBuilder builder = new StringBuilder();
        while ((i = part.indexOf("%", i)) >= 0) {
            if (i > l - 3 || !BaseURIUtil.isHex(part.charAt(i + 1)) || !BaseURIUtil.isHex(part.charAt(i + 2))) {
                builder.append(part.substring(j, i));
                builder.append("%25");
                j = i + 1;
            }
            ++i;
        }
        if (j < l) {
            builder.append(part.substring(j));
        }
        String verified = builder.toString();
        return verified;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean needDecode(String p) {
        if (p == null || p.length() == 0) {
            return false;
        }
        return p.indexOf("%") >= 0 || p.indexOf("+") >= 0;
    }

    private static String copyProtocol(String encodedURI, StringBuilder builder) {
        int i = encodedURI.indexOf("://");
        String ret = null;
        if (i > 0) {
            builder.append(encodedURI.substring(0, i + 3));
            ret = encodedURI.substring(i + 3);
        }
        return ret == null ? encodedURI : ret;
    }
}

