/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.transform;

import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationManager;
import com.ibm.es.nuvo.util.transform.TransformIOException;
import java.io.IOException;
import java.io.InputStream;

public class TransformedDocumentInputStream
extends InputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private InputStream input = null;

    public TransformedDocumentInputStream(InputStream srcInput, String format, TransformationManager manager) throws TransformIOException, IOException {
        try {
            this.input = manager.transform(srcInput, format);
        }
        catch (TransformationException dpe) {
            throw new TransformIOException(dpe);
        }
        if (this.input == null) {
            throw new TransformIOException(10L);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.input.read(b, off, len);
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.input.read();
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.input == null) {
            throw new IOException("stream is closed.");
        }
    }
}

