/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.threadpool;

import com.ibm.es.nuvo.util.threadpool.Task;
import com.ibm.es.nuvo.util.threadpool.TaskPoolEventListener;
import com.ibm.es.nuvo.util.threadpool.ThreadedQueue;
import java.util.ArrayList;

public class TaskPool {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ThreadedQueue workQueue;
    private ArrayList<PoolWorker> workers;
    private ArrayList<TaskPoolEventListener> listeners;
    private boolean scheduleTasks = true;
    private int poolWorkerIndex;

    public TaskPool(int numThreads) {
        this.workers = new ArrayList(numThreads);
        this.workQueue = new ThreadedQueue();
        for (int i = 0; i < numThreads; ++i) {
            this.addPoolWorker();
        }
    }

    public synchronized void schedule(Runnable task) {
        if (!this.scheduleTasks) {
            return;
        }
        this.workQueue.enqueue(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TaskPool taskPool = this;
        synchronized (taskPool) {
            this.scheduleTasks = false;
        }
        this.workQueue.signalEOF();
        for (int i = 0; i < this.workers.size(); ++i) {
            PoolWorker worker = this.workers.get(i);
            try {
                worker.interrupt();
                worker.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void shutdown(Runnable task) {
        for (int i = 0; i < this.workers.size(); ++i) {
            PoolWorker worker = this.workers.get(i);
            if (worker.getRunnable() != task) continue;
            worker.interrupt();
        }
    }

    public void addListener(TaskPoolEventListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public void notifyListeners(Object o) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TaskPoolEventListener l = this.listeners.get(i);
            l.update(o);
        }
    }

    private void addPoolWorker() {
        PoolWorker pw = new PoolWorker();
        pw.setName("PoolWorker-" + this.poolWorkerIndex++);
        this.workers.add(pw);
        pw.start();
    }

    private class PoolWorker
    extends Thread {
        Runnable r = null;

        private PoolWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                this.r = (Runnable)TaskPool.this.workQueue.dequeue();
                if (this.r == null) {
                    return;
                }
                try {
                    this.r.run();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (this.r instanceof Task) {
                        ((Task)this.r).notifyListeners();
                    }
                    this.r = null;
                    continue;
                }
                break;
            }
        }

        public Runnable getRunnable() {
            return this.r;
        }
    }
}

