/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class DocumentFieldOutputStream
extends OutputStream {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Document document;
    private final String fieldName;
    private int fieldCount;
    private byte[] buffer;
    private final int bufferSize;
    private int position;
    private boolean compress;

    public DocumentFieldOutputStream(Document doc, String outputFieldName, int bufferSize) {
        this.fieldName = outputFieldName;
        this.document = doc;
        this.fieldCount = 0;
        this.bufferSize = bufferSize;
        this.newBuffer();
    }

    public DocumentFieldOutputStream(Document doc, String outputFieldName) {
        this(doc, outputFieldName, 4096);
    }

    private byte[] newBuffer() {
        this.buffer = new byte[this.bufferSize];
        this.position = 0;
        return this.buffer;
    }

    private void flushBuffer() {
        byte[] bufferToStore;
        if (this.position == this.bufferSize) {
            bufferToStore = this.buffer;
            this.newBuffer();
        } else {
            bufferToStore = new byte[this.position];
            System.arraycopy(this.buffer, 0, bufferToStore, 0, this.position);
            this.position = 0;
        }
        String name = this.fieldCount == 0 ? this.fieldName : this.fieldName + this.fieldCount;
        Field field = new Field(name, bufferToStore, Field.Store.YES);
        this.document.add((Fieldable)field);
        ++this.fieldCount;
    }

    private int writeToBuffer(byte[] b, int off, int len) {
        int capacity = this.buffer.length - this.position;
        if (capacity > len) {
            System.arraycopy(b, off, this.buffer, this.position, len);
            this.position += len;
            return len;
        }
        System.arraycopy(b, off, this.buffer, this.position, capacity);
        this.position += capacity;
        return capacity;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int remain = len;
        while (remain > 0) {
            int actual = this.writeToBuffer(b, off, remain);
            remain -= actual;
            off += actual;
            if (this.position < this.buffer.length) continue;
            this.flushBuffer();
        }
    }

    public void write(int b) throws IOException {
        if (this.position >= this.bufferSize) {
            this.flushBuffer();
        }
        this.buffer[this.position] = (byte)b;
        ++this.position;
    }

    public void flush() {
        if (this.position > 0) {
            this.flushBuffer();
        }
    }

    public void close() {
        this.flush();
    }
}

