/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class DocumentFieldInputStream
extends InputStream {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    Document doc;
    String fieldName;
    int fieldCount;
    byte[] buffer;
    int bufferSize;
    int position;

    public DocumentFieldInputStream(Document doc, String inputFieldName) {
        this.doc = doc;
        this.fieldName = inputFieldName;
    }

    private boolean nextBuffer() {
        Field field = this.fieldCount == 0 ? this.doc.getField(this.fieldName) : this.doc.getField(this.fieldName + this.fieldCount);
        ++this.fieldCount;
        if (field != null) {
            this.buffer = field.binaryValue();
            if (this.buffer != null) {
                this.bufferSize = this.buffer.length;
                this.position = 0;
                return true;
            }
        }
        this.buffer = null;
        this.bufferSize = 0;
        return false;
    }

    public int read() throws IOException {
        if (!(this.buffer != null && this.position < this.bufferSize || this.nextBuffer())) {
            return -1;
        }
        int value = this.buffer[this.position] & 0xFF;
        ++this.position;
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            if (this.buffer != null && this.position < this.bufferSize) {
                int size = this.bufferSize - this.position;
                if (size > len) {
                    size = len;
                }
                System.arraycopy(this.buffer, this.position, b, off, size);
                this.position += size;
                off += size;
                len -= size;
                read += size;
            }
            if (len <= 0 || this.nextBuffer()) continue;
            return read == 0 ? -1 : read;
        }
        return read;
    }
}

