/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.servlet;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.Loggers;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class ServletErrorHandler {
    public static void handleErrorNoThrow(ServletRequest request, ServletResponse response, Throwable t) {
        ServletErrorHandler.logServletError(request, response, t);
    }

    public static void handleError(ServletRequest request, ServletResponse response, Throwable t) throws ServletException {
        ServletErrorHandler.logServletError(request, response, t);
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        ServletException toThrow = new ServletException(t);
        toThrow.initCause(t);
        throw toThrow;
    }

    public static void logServletError(ServletRequest request, ServletResponse response, Throwable cause) {
        Message msg = new Message("G0024E.SERVLET_UNEXPECTED_ERROR", request, response);
        ExtendedException ee = new ExtendedException(msg, cause);
        Loggers.logger.log(ee);
    }

    public static void log(String message, Throwable cause) {
        Message msg = new Message("G0024E.SERVLET_UNEXPECTED_ERROR", message, "");
        ExtendedException ee = new ExtendedException(msg, cause);
        Loggers.logger.log(ee);
    }
}

