/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.remoteprocess.worker.fenced;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import com.ibm.es.nuvo.util.remoteprocess.worker.Worker;
import com.ibm.es.nuvo.util.remoteprocess.worker.WorkerTimeoutException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFencedWorker
implements Worker {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final int BUFFER_SIZE = 16384;
    public static final String BUFFER_SIZE_PROP = "BufferSize";
    protected static final int CACHE_INITSIZE = 0x100000;
    public static final String CACHE_INITSIZE_PROP = "CacheInitSize";
    protected static final int CACHE_THRESHOLD = 0x800000;
    public static final String CACHE_THRESHOLD_PROP = "ChacheThreshold";
    private static final int MESSAGE_SIZE = 8;
    private static final int HEARTBEAT_TIMEOUT = 5000;
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected final Process process;
    protected final BufferedInputStream dis;
    protected final BufferedOutputStream dos;
    private final HeartBeatTask heatBeatTask;
    protected int bufferSize = 16384;
    protected int initCacheSize = 0x100000;
    protected int thresholdCasheSize = 0x800000;

    protected AbstractFencedWorker(Process process) throws RemoteProcessException {
        this.process = process;
        this.dis = new BufferedInputStream(this.process.getInputStream());
        this.dos = new BufferedOutputStream(this.process.getOutputStream());
        this.heatBeatTask = new HeartBeatTask();
        try {
            this.process.getErrorStream().close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            int exitValue = this.process.exitValue();
            Message message = new Message("G0146E.WORKERPROCESS_HAS_BEEN_DIED");
            message.addArgument(exitValue);
            throw new RemoteProcessException(message);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return;
        }
    }

    @Override
    public final void destroy() throws RemoteProcessException {
        try {
            this.sendMessage(2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.executorService.shutdownNow();
        this.process.destroy();
    }

    @Override
    public boolean isAvailable() throws RemoteProcessException {
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            try {
                this.checkHeartBeat();
            }
            catch (WorkerTimeoutException te) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public abstract InputStream process(InputStream var1, Map<String, String> var2, long var3) throws WorkerTimeoutException, RemoteProcessException;

    private final void checkHeartBeat() throws WorkerTimeoutException, RemoteProcessException {
        Future<Object> f = this.executorService.submit(this.heatBeatTask);
        try {
            f.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RemoteProcessException(e);
        }
        catch (ExecutionException e) {
            throw new RemoteProcessException(e);
        }
        catch (TimeoutException e) {
            f.cancel(true);
            throw new WorkerTimeoutException(e);
        }
    }

    private final void checkHeartBeatActual() throws RemoteProcessException {
        this.sendMessage(0);
        int retMessage = this.readMessage();
        if (retMessage != 0) {
            Message message = new Message("G0148E.WORKERPROCESS_UNEXPECTED_STATE");
            message.addArgument(retMessage);
            throw new RemoteProcessException(message);
        }
    }

    protected void sendDataSize(int size) throws RemoteProcessException {
        byte[] messageBytes = this.to8HexString(size).getBytes();
        try {
            this.dos.write(messageBytes);
        }
        catch (IOException ioe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)ioe);
        }
    }

    protected void sendString(String messageStr) throws RemoteProcessException {
        byte[] messageBytes = null;
        try {
            messageBytes = messageStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            messageBytes = messageStr.getBytes();
        }
        int length = messageBytes.length;
        this.sendDataSize(length);
        int alreadyWritten = 0;
        try {
            while (length > alreadyWritten) {
                if (length - alreadyWritten <= this.bufferSize) {
                    this.dos.write(messageBytes, alreadyWritten, length - alreadyWritten);
                    this.dos.flush();
                    alreadyWritten += length - alreadyWritten;
                    continue;
                }
                this.dos.write(messageBytes, alreadyWritten, this.bufferSize);
                this.dos.flush();
                alreadyWritten += this.bufferSize;
            }
        }
        catch (IOException ioe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)ioe);
        }
    }

    protected final void sendMessage(int sentMessage) throws RemoteProcessException {
        byte[] messageBytes = this.to8HexString(sentMessage).getBytes();
        try {
            this.dos.write(messageBytes);
            this.dos.flush();
        }
        catch (IOException ioe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)ioe);
        }
    }

    protected final String to8HexString(int num) {
        StringBuffer retBuf = new StringBuffer();
        String tempHex = Integer.toHexString(num);
        for (int i = 0; i < 8 - tempHex.length(); ++i) {
            retBuf.append("0");
        }
        retBuf.append(tempHex);
        return retBuf.toString();
    }

    protected final int readMessage() throws RemoteProcessException {
        int retVal = 1;
        byte[] messageBuf = new byte[8];
        byte[] tempBuf = new byte[8];
        try {
            int len = this.dis.read(messageBuf, 0, 8);
            if (len < 0) {
                throw new RemoteProcessException(new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED"));
            }
            for (int offset = len; offset < 8; offset += len) {
                len = this.dis.read(tempBuf, 0, 8 - offset);
                if (len < 0) {
                    throw new RemoteProcessException(new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED"));
                }
                System.arraycopy(tempBuf, 0, messageBuf, offset, len);
            }
        }
        catch (IOException ioe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)ioe);
        }
        String messageStr = new String(messageBuf);
        try {
            retVal = Integer.valueOf(messageStr, 16);
        }
        catch (NumberFormatException nfe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)nfe);
        }
        return retVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HeartBeatTask
    implements Callable<Object> {
        private HeartBeatTask() {
        }

        @Override
        public Object call() throws RemoteProcessException {
            AbstractFencedWorker.this.checkHeartBeatActual();
            return null;
        }
    }
}

