/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.remoteprocess.manager.fenced;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import com.ibm.es.nuvo.util.remoteprocess.manager.WorkerManager;
import com.ibm.es.nuvo.util.remoteprocess.worker.Worker;
import com.ibm.es.nuvo.util.remoteprocess.worker.fenced.FencedWorkerFactory;
import java.util.Properties;

public class FencedWorkerManager
implements WorkerManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static int INIT_POOL_SIZE = 1;
    private static int MAX_POOLSIZE = 1;
    private WorkerAdmin[] administratedWorkers = null;
    private final FencedWorkerFactory workerFactory;
    private Properties workerProps;

    public FencedWorkerManager(FencedWorkerFactory workerFactory) throws RemoteProcessException {
        this.workerFactory = workerFactory;
    }

    public synchronized Worker getAvailableWorker() throws RemoteProcessException {
        boolean isAnyElementEmpty = false;
        int firstEmptyElement = 0;
        for (int i = 0; i < this.administratedWorkers.length; ++i) {
            if (this.administratedWorkers[i] != null && !this.administratedWorkers[i].isInUse()) {
                this.administratedWorkers[i].setInUse(true);
                Worker aWorker = this.administratedWorkers[i].getWorker();
                if (aWorker.isAvailable()) {
                    return this.administratedWorkers[i].getWorker();
                }
                aWorker.destroy();
                this.administratedWorkers[i] = null;
                isAnyElementEmpty = true;
                if (firstEmptyElement >= i) continue;
                firstEmptyElement = i;
                continue;
            }
            if (isAnyElementEmpty || this.administratedWorkers[i] != null) continue;
            isAnyElementEmpty = true;
            firstEmptyElement = i;
        }
        if (isAnyElementEmpty) {
            Worker newWorker = this.workerFactory.createWorker(this.workerProps);
            if (newWorker != null && newWorker.isAvailable()) {
                this.administratedWorkers[firstEmptyElement] = new WorkerAdmin(newWorker);
                this.administratedWorkers[firstEmptyElement].setInUse(true);
                return this.administratedWorkers[firstEmptyElement].getWorker();
            }
            if (newWorker != null) {
                newWorker.destroy();
            }
            throw new RemoteProcessException(new Message("G0145E.WORKERPROCESS_CREATE_FAILED"));
        }
        throw new RemoteProcessException(new Message("G0144E.WORKERPROCESS_NO_AVAILABLE_PROCESS"));
    }

    public synchronized void initialize() throws RemoteProcessException {
        this.initialize(INIT_POOL_SIZE, MAX_POOLSIZE);
    }

    public synchronized void initialize(int initPoolSize, int maxPoolSize) throws RemoteProcessException {
        this.workerProps = new Properties();
        if (maxPoolSize <= 0 || initPoolSize < 0 || initPoolSize > maxPoolSize) {
            Message message = new Message("G0007E.INVALID_ARGUMENT", "initPoolSize ot maxPoolSize");
            throw new RemoteProcessException(message);
        }
        this.administratedWorkers = new WorkerAdmin[maxPoolSize];
        try {
            for (int i = 0; i < initPoolSize; ++i) {
                Worker aWorker = this.workerFactory.createWorker(this.workerProps);
                this.administratedWorkers[i] = new WorkerAdmin(aWorker);
            }
        }
        catch (RemoteProcessException rpe) {
            throw new RemoteProcessException(new Message("G0143E.WORKERPROCESS_INITIAL_FAILED"), (Throwable)rpe);
        }
    }

    public synchronized void terminate() throws RemoteProcessException {
        for (int i = 0; i < this.administratedWorkers.length; ++i) {
            if (this.administratedWorkers[i] == null) continue;
            Worker aWorker = this.administratedWorkers[i].getWorker();
            if (aWorker != null) {
                aWorker.destroy();
            }
            this.administratedWorkers[i] = null;
        }
    }

    public synchronized void releaseWorker(Worker releasedWorker) {
        for (int i = 0; i < this.administratedWorkers.length; ++i) {
            if (this.administratedWorkers[i] == null || this.administratedWorkers[i].getWorker() != releasedWorker) continue;
            this.administratedWorkers[i].inUse = false;
        }
    }

    public synchronized void destroyWorker(Worker unnecessaryWorker) throws RemoteProcessException {
        for (int i = 0; i < this.administratedWorkers.length; ++i) {
            if (this.administratedWorkers[i] == null || this.administratedWorkers[i].getWorker() != unnecessaryWorker) continue;
            this.administratedWorkers[i] = null;
        }
        unnecessaryWorker.destroy();
    }

    private static class WorkerAdmin {
        boolean inUse = false;
        Worker worker = null;

        private WorkerAdmin(Worker worker) {
            this.worker = worker;
        }

        private boolean isInUse() {
            return this.inUse;
        }

        private void setInUse(boolean inUse) {
            this.inUse = inUse;
        }

        private Worker getWorker() {
            return this.worker;
        }
    }
}

