/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser.rule;

import com.ibm.es.nuvo.util.parser.Parser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Parser parser;

    public abstract void begin(Attributes var1) throws Exception;

    public void end() throws Exception {
    }

    public void chars(String value) throws Exception {
    }

    protected Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    protected void invokeMethod(Object object, String name, String value) throws IllegalAccessException, InvocationTargetException {
        if (object == null || name == null || value == null) {
            return;
        }
        this.invokeMethod(object, object.getClass().getMethods(), name, value);
    }

    protected void invokeMethod(Object object, Method[] methods, String name, String value) throws IllegalAccessException, InvocationTargetException {
        if (object == null || methods == null || name == null || value == null) {
            return;
        }
        Method method = this.getMethod(methods, name, 1);
        if (method == null) {
            return;
        }
        Class<?> cls = method.getParameterTypes()[0];
        this.invokeMethod(method, object, new Object[]{this.convert(value, cls)});
    }

    protected Object invokeMethod(Method method, Object object, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(object, arguments);
    }

    protected Object convert(String value, Class<?> cls) {
        if (cls == String.class || cls == Object.class) {
            return value;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.parseInt(value);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.parseLong(value);
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.parseShort(value);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.parseDouble(value);
        }
        System.out.println(value + " " + cls.getName());
        return null;
    }

    protected Method getMethod(Method[] methods, String name, int numArgs) {
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(name) || method.getParameterTypes() == null || method.getParameterTypes().length != numArgs) continue;
            return method;
        }
        return null;
    }
}

