/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser.rule;

import com.ibm.es.nuvo.util.parser.rule.MethodRule;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;

public class CallMethodRule
extends MethodRule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String[] args;
    private Object[] defaults;
    private Object obj;
    private Method method;
    private Object[] tmpargs;

    public CallMethodRule(String method, String[] args, Object[] defaults) {
        super(method);
        if (null != args) {
            this.args = new String[args.length];
            System.arraycopy(args, 0, this.args, 0, args.length);
        }
        if (null != defaults) {
            this.defaults = new Object[defaults.length];
            System.arraycopy(defaults, 0, this.defaults, 0, defaults.length);
        }
    }

    public CallMethodRule(String method) {
        super(method);
    }

    public void begin(Attributes attributes) throws Exception {
        Object object;
        Method m;
        if (this.args == null) {
            this.args = new String[0];
        }
        Object[] arguements = new Object[this.args.length];
        if (this.defaults != null && this.defaults.length == this.args.length) {
            System.arraycopy(this.defaults, 0, arguements, 0, arguements.length);
        }
        if ((m = this.getMethod((object = this.getParser().peek()).getClass().getMethods(), this.getMethod(), arguements.length)) == null) {
            return;
        }
        Class<?>[] params = m.getParameterTypes();
        int i = 0;
        boolean needBody = false;
        for (String argName : this.args) {
            if (argName == null) {
                needBody = true;
            }
            String value = attributes.getValue(argName);
            Class<?> cls = params[i];
            if (value != null) {
                arguements[i] = this.convert(value, cls);
            }
            ++i;
        }
        if (!needBody) {
            this.invokeMethod(m, object, arguements);
        } else {
            this.method = m;
            this.obj = object;
            this.tmpargs = arguements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chars(String value) throws Exception {
        if (value == null) {
            return;
        }
        value = value.trim();
        if (this.method != null) {
            try {
                Object[] arguements = this.tmpargs;
                this.tmpargs = null;
                Class<?>[] params = this.method.getParameterTypes();
                int i = 0;
                for (String argName : this.args) {
                    if (argName == null) {
                        Class<?> cls = params[i];
                        if (value == null) break;
                        arguements[i] = this.convert(value, cls);
                        break;
                    }
                    ++i;
                }
                this.invokeMethod(this.method, this.obj, arguements);
            }
            finally {
                this.method = null;
                this.obj = null;
                this.tmpargs = null;
            }
        } else {
            if (this.args != null && this.args.length > 0) {
                return;
            }
            this.invokeMethod(this.getParser().peek(), this.getMethod(), value);
        }
    }
}

