/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser;

import com.ibm.es.nuvo.util.parser.ISAXElementTracker;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXXMLToObjectMapper
extends DefaultHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private Stack<ISAXElementTracker> elementTrackerStack;
    private SAXParser saxParser;
    private XMLReader xr;
    private CharArrayWriter contentCharBuffer;

    public SAXXMLToObjectMapper() {
        try {
            this.elementTrackerStack = new Stack();
            this.contentCharBuffer = new CharArrayWriter();
            this.saxParser = saxParserFactory.newSAXParser();
            this.xr = this.saxParser.getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("sax initialization failed");
        }
        this.elementTrackerStack.push(this.createSAXElementTrackerNetwork());
    }

    public abstract ISAXElementTracker createSAXElementTrackerNetwork();

    public abstract Object getObject();

    public final Object mapXMLFrom(InputStream in) {
        try {
            return this.mapXMLFrom(new InputSource(in));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Object mapXMLFrom(Reader in) {
        try {
            return this.mapXMLFrom(new InputSource(in));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Object mapXMLFrom(String url) {
        try {
            return this.mapXMLFrom(new InputSource(url));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final synchronized Object mapXMLFrom(InputSource in) throws Exception {
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(this);
        this.xr.parse(in);
        return this.getObject();
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        String eName = localName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.contentCharBuffer.reset();
        ISAXElementTracker activeTracker = this.elementTrackerStack.peek();
        activeTracker.startElement(namespaceURI, eName, qName, attr, this.elementTrackerStack);
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        this.contentCharBuffer.write(ch, start, length);
    }

    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String eName = localName;
        if ("".equals(eName)) {
            eName = qName;
        }
        ISAXElementTracker activeTracker = this.elementTrackerStack.peek();
        activeTracker.endElement(namespaceURI, eName, qName, this.contentCharBuffer, this.elementTrackerStack);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    static {
        saxParserFactory.setValidating(false);
    }
}

