/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser;

import com.ibm.es.nuvo.util.parser.ISAXElementTracker;
import com.ibm.es.nuvo.util.parser.SAXSkipElementTracker;
import java.io.CharArrayWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXElementTracker
implements ISAXElementTracker {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ISAXElementTracker skipElementTracker = new SAXSkipElementTracker();
    private Map<String, ISAXElementTracker> trackers = new HashMap<String, ISAXElementTracker>();

    @Override
    public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
    }

    @Override
    public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter contents) {
    }

    @Override
    public void onDeactivate() {
    }

    @Override
    public void onReactivate() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr, Stack<ISAXElementTracker> tagStack) {
        ISAXElementTracker tracker;
        String eName = localName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if ((tracker = this.trackers.get(eName)) == null) {
            tagStack.push(skipElementTracker);
        } else {
            this.onDeactivate();
            tracker.onStart(namespaceURI, eName, qName, attr);
            tagStack.push(tracker);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName, CharArrayWriter contents, Stack<ISAXElementTracker> tagStack) {
        String eName = localName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.onEnd(namespaceURI, eName, qName, contents);
        tagStack.pop();
        ISAXElementTracker activeTracker = tagStack.peek();
        if (activeTracker != null) {
            activeTracker.onReactivate();
        }
    }

    @Override
    public void trackElement(String tagName, ISAXElementTracker tracker) {
        int slashOffset = tagName.indexOf("/");
        if (slashOffset < 0) {
            this.trackers.put(tagName, tracker);
        } else if (slashOffset == 0) {
            this.trackElement(tagName.substring(1), tracker);
        } else {
            String topTagName = tagName.substring(0, slashOffset);
            String remainderOfTagName = tagName.substring(slashOffset + 1);
            ISAXElementTracker child = this.trackers.get(topTagName);
            if (child == null) {
                child = new SAXElementTracker();
                this.trackers.put(topTagName, child);
            }
            child.trackElement(remainderOfTagName, tracker);
        }
    }
}

