/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser;

import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.ParseTreeNode;
import com.ibm.es.nuvo.util.parser.UnsupportedTypeException;
import com.ibm.es.nuvo.util.parser.rule.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Stack<ParseTreeNode> stack = new Stack();
    private Stack<Object> targets = new Stack();
    private ParseTreeNode currentNode;
    private StringBuilder buffer;
    private SAXParser parser;
    private ParseTree tree;
    private Stack<Object> objectStack = new Stack();

    public Parser() throws ParseException {
        try {
            SAXParserFactory instance = SAXParserFactory.newInstance();
            instance.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            instance.setFeature("http://xml.org/sax/features/validation", false);
            this.parser = instance.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("Cannot create parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException("Cannot create parser", (Throwable)e);
        }
    }

    public void parse(InputStream is, ParseTree parseTree, Object obj) throws ParseException {
        this.tree = parseTree;
        this.currentNode = parseTree.getRoot();
        this.objectStack.push(obj);
        this.targets.push(obj);
        try {
            this.parser.parse(is, (DefaultHandler)this);
        }
        catch (IOException e) {
            throw new ParseException("Cannot parse document ", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException("Cannot parse document ", (Throwable)e);
        }
        finally {
            this.stack.clear();
            this.objectStack.clear();
            this.targets.clear();
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localname, String qName, Attributes attributes) {
        Vector<ParseTreeNode> children = this.currentNode.getChildren();
        qName = this.stripNameSpace(qName);
        for (ParseTreeNode node : children) {
            List<Rule> rules;
            if (!node.getElementName().equals(qName)) continue;
            this.buffer = new StringBuilder();
            this.currentNode = node;
            this.stack.push(this.currentNode);
            try {
                this.dispatchStartElementMethod(this.currentNode);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            catch (UnsupportedTypeException e1) {
                e1.printStackTrace();
            }
            if ((rules = node.getRules()) == null) continue;
            try {
                for (Rule rule : rules) {
                    rule.setParser(this);
                    rule.begin(attributes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String stripNameSpace(String qName) {
        int l = qName.indexOf(58);
        if (l > 0) {
            qName = qName.substring(l + 1);
        }
        return qName;
    }

    public void endElement(String namespaceURI, String localname, String qName) throws SAXException {
        if (this.stack.size() == 0) {
            return;
        }
        ParseTreeNode node = this.stack.peek();
        qName = this.stripNameSpace(qName);
        if (node.getElementName().equals(qName)) {
            List<Rule> rules = node.getRules();
            if (rules != null) {
                try {
                    if (this.buffer.length() > 0) {
                        String value = this.buffer.toString();
                        for (Rule rule : rules) {
                            rule.chars(value);
                        }
                    }
                    for (int i = rules.size() - 1; i >= 0; --i) {
                        rules.get(i).end();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.currentNode.isTreeLeaf() && this.currentNode.getEndElementMethodName() != null) {
                try {
                    this.dispatchMethod(node);
                }
                catch (ParseException e) {
                    throw new SAXException("Cannot parse configuration ", e);
                }
                catch (UnsupportedTypeException e) {
                    throw new SAXException("Cannot parse configuration ", e);
                }
            }
            this.stack.pop();
            this.currentNode = this.stack.isEmpty() ? this.tree.getRoot() : this.stack.peek();
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    private void dispatchStartElementMethod(ParseTreeNode node) throws ParseException, UnsupportedTypeException {
        String methodName = node.getStartElementMethodName();
        if (methodName == null) {
            this.objectStack.push(this.objectStack.peek());
        } else {
            Method m;
            Class[] parameterTypes = new Class[]{Object.class};
            Object o = this.objectStack.peek();
            try {
                m = o.getClass().getMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                throw new ParseException("Cannot access method to set property ", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ParseException("Cannot find method " + methodName + " to set property", (Throwable)e);
            }
            Object[] parameters = new Object[]{o};
            try {
                Object resultObject = m.invoke(o, parameters);
                if (resultObject == null) {
                    resultObject = this.objectStack.peek();
                }
                this.objectStack.push(resultObject);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void dispatchMethod(ParseTreeNode node) throws ParseException, UnsupportedTypeException {
        Method m;
        String methodName = node.getEndElementMethodName();
        Class[] parameterTypes = new Class[]{node.getParameterType()};
        Object o = this.objectStack.pop();
        try {
            m = o.getClass().getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new ParseException("Cannot access method to set property ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException("Cannot find method " + methodName + " to set property", (Throwable)e);
        }
        Object[] parameters = new Object[1];
        if (node.getParameterType() == String.class) {
            parameters[0] = this.buffer.toString();
        } else if (node.getParameterType() == Integer.TYPE) {
            parameters[0] = new Integer(Integer.parseInt(this.buffer.toString()));
        } else if (node.getParameterType() == Double.TYPE) {
            parameters[0] = new Double(Double.parseDouble(this.buffer.toString()));
        } else if (node.getParameterType() == Long.TYPE) {
            parameters[0] = new Long(Long.parseLong(this.buffer.toString()));
        } else if (node.getParameterType() == Boolean.TYPE) {
            parameters[0] = new Boolean(Boolean.parseBoolean(this.buffer.toString()));
        } else {
            throw new UnsupportedTypeException("does not support type " + node.getParameterType().toString());
        }
        try {
            m.invoke(o, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Illegal argument for method " + methodName + " to set property", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ParseException("Illegal access for method " + methodName + " to set property", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ParseException("Invocation target for method " + methodName + " to set property", (Throwable)e);
        }
    }

    public void push(Object obj) {
        this.targets.push(obj);
    }

    public Object pop() {
        return this.targets.pop();
    }

    public Object peek() {
        return this.targets.peek();
    }
}

