/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.parser;

import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTreeNode;
import com.ibm.es.nuvo.util.parser.rule.CallMethodRule;
import com.ibm.es.nuvo.util.parser.rule.Rule;
import com.ibm.es.nuvo.util.parser.rule.SetAttributeRule;
import com.ibm.es.nuvo.util.parser.rule.SubComponentRule;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTree {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ParseTreeNode root = new ParseTreeNode("$ROOT$");

    public ParseTreeNode getRoot() {
        return this.root;
    }

    public void addPath(String path, String methodName) throws ParseException {
        this.addPath(path, null, methodName, String.class);
    }

    public void addPath(String path, String startElementMethodName, String endElementMethodName) throws ParseException {
        this.addPath(path, startElementMethodName, endElementMethodName, String.class);
    }

    public void addPath(String path, String endElementMethodName, Class<?> parameterType) throws ParseException {
        this.addPath(path, null, endElementMethodName, parameterType);
    }

    public void addPath(String path, String startElementMethodName, String endElementMethodName, Class<?> parameterType) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
        ParseTreeNode current = this.root;
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            Vector<ParseTreeNode> children = current.getChildren();
            ParseTreeNode match = null;
            int index = 0;
            while (match == null && index < children.size()) {
                ParseTreeNode node = children.elementAt(index);
                if (node.getElementName().equals(token)) {
                    match = node;
                    continue;
                }
                ++index;
            }
            if (match != null) {
                current = match;
                continue;
            }
            current = current.addNode(new ParseTreeNode(token, parameterType));
        }
        if (current.getEndElementMethodName() != null) {
            throw new ParseException("Duplicated path specification");
        }
        current.setMethodNames(startElementMethodName, endElementMethodName);
    }

    public void addPath(String path, Rule rule) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
        ParseTreeNode current = this.root;
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            Vector<ParseTreeNode> children = current.getChildren();
            ParseTreeNode match = null;
            int index = 0;
            while (match == null && index < children.size()) {
                ParseTreeNode node = children.elementAt(index);
                if (node.getElementName().equals(token)) {
                    match = node;
                    continue;
                }
                ++index;
            }
            if (match != null) {
                current = match;
                continue;
            }
            current = current.addNode(new ParseTreeNode(token));
        }
        current.addRule(rule);
    }

    public String toString() {
        return this.toStringHelper(0, this.root);
    }

    public String toStringHelper(int indentation, ParseTreeNode node) {
        StringBuffer buffer = new StringBuffer();
        Vector<ParseTreeNode> children = node.getChildren();
        if (children.size() == 0) {
            buffer.append("\n");
            for (int j = 0; j < indentation; ++j) {
                buffer.append(" ");
            }
            buffer.append(node.getElementName());
            String endElementMethodName = node.getEndElementMethodName();
            buffer.append("[" + endElementMethodName + "]");
        } else {
            for (int i = 0; i < children.size(); ++i) {
                ParseTreeNode child = children.elementAt(i);
                buffer.append("\n");
                for (int j = 0; j < indentation; ++j) {
                    buffer.append(" ");
                }
                buffer.append(node.getElementName());
                String methodName = node.getEndElementMethodName();
                buffer.append("[" + methodName + "]");
                buffer.append(this.toStringHelper(indentation + 5, child));
            }
        }
        return buffer.toString();
    }

    public void addCallMethod(String path, String method, String[] args, Object[] defaults) {
        this.addPath(path, new CallMethodRule(method, args, defaults));
    }

    public void addCallMethod(String path, String method) {
        this.addPath(path, new CallMethodRule(method));
    }

    public void addSetSubcomponent(String path, String method) {
        this.addPath(path, new SubComponentRule(method));
    }

    public void addSetSubcomponent(String path, String method, String[] args, Object[] defaults) {
        this.addPath(path, new SubComponentRule(method, args, defaults));
    }

    public void addAttributesRule(String path) {
        this.addPath(path, new SetAttributeRule());
    }

    public void addAttributesRule(String path, Map<String, String> map) {
        this.addPath(path, new SetAttributeRule(map));
    }
}

