/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.decimal;

import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalEquals;
import com.ibm.es.nuvo.util.decimal.DecimalLower;
import com.ibm.es.nuvo.util.decimal.DecimalNotEquals;
import com.ibm.es.nuvo.util.decimal.DecimalTermDocs;
import com.ibm.es.nuvo.util.decimal.DecimalUpper;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class DecimalTermPositions
extends DecimalTermDocs {
    private ArrayList<Decimal> values = new ArrayList();
    private ArrayList<Integer> positions = new ArrayList();
    private int posCursor = 0;

    public DecimalTermPositions(IndexReader reader, Term term, DecimalCondition condition) throws IOException {
        super(reader, term, condition);
    }

    protected void findAllValues(Decimal firstValue, int firstPos, int remainingPositions) throws IOException {
        this.posCursor = -1;
        this.values.clear();
        this.positions.clear();
        this.values.add(firstValue);
        this.positions.add(firstPos);
        this.findRemainingValues(remainingPositions);
    }

    void findRemainingValues(int frequency) throws IOException {
        while (frequency > 1) {
            int pos = this.termPos.nextPosition();
            int payloadLength = this.termPos.getPayloadLength();
            byte[] payload = this.termPos.getPayload(this.payloadBytes, 0);
            Decimal value = Decimal.fromByteArray(payload, payloadLength);
            if (this.condition.check(value)) {
                this.values.add(value);
                this.positions.add(pos);
            }
            --frequency;
        }
    }

    public int nextPosition() {
        ++this.posCursor;
        return this.positions.get(this.posCursor);
    }

    public Decimal value() {
        return this.values.get(this.posCursor);
    }

    public int freq() {
        return this.values.size();
    }

    public static void main(String[] args) throws CorruptIndexException, IOException {
        String indexDir = args[0];
        String field = args[1];
        String name = args[2];
        String op = args[3];
        String value = args[4];
        IndexReader reader = IndexReader.open((String)indexDir);
        Term term = new Term(field, name);
        Decimal dec = Decimal.parseDecimal(value, 3);
        DecimalCondition check = null;
        if (op.equals("=")) {
            check = new DecimalEquals(dec);
        } else if (op.equals("!=")) {
            check = new DecimalNotEquals(dec);
        } else if (op.equals(">")) {
            check = new DecimalLower(dec, false);
        } else if (op.equals(">=")) {
            check = new DecimalLower(dec, true);
        } else if (op.equals("<")) {
            check = new DecimalUpper(dec, false);
        } else if (op.equals("<=")) {
            check = new DecimalUpper(dec, false);
        }
        DecimalTermPositions termPos = new DecimalTermPositions(reader, term, check);
        while (termPos.next()) {
            System.out.println("doc " + termPos.doc() + "[freq = " + termPos.freq() + "]: ");
            for (int i = 0; i < termPos.freq(); ++i) {
                System.out.println(termPos.nextPosition() + ":" + termPos.value() + " ");
            }
        }
    }
}

