/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.decimal;

import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;

public class DecimalTermDocs {
    protected DecimalCondition condition;
    protected TermPositions termPos;
    protected int docId;
    protected byte[] payloadBytes = new byte[9];

    public DecimalTermDocs(IndexReader reader, Term term, DecimalCondition condition) throws IOException {
        this.condition = condition;
        this.termPos = reader.termPositions(term);
        this.docId = -1;
    }

    public void close() throws IOException {
        this.termPos.close();
    }

    public int doc() {
        return this.docId;
    }

    public boolean next() throws IOException {
        if (this.termPos.next()) {
            return this.checkValues();
        }
        return false;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.termPos.skipTo(target)) {
            return this.checkValues();
        }
        return false;
    }

    private boolean checkValues() throws IOException {
        if (this.findValue()) {
            return true;
        }
        while (this.termPos.next()) {
            if (!this.findValue()) continue;
            return true;
        }
        return false;
    }

    private boolean findValue() throws IOException {
        for (int frequency = this.termPos.freq(); frequency > 0; --frequency) {
            int pos = this.termPos.nextPosition();
            int payloadLength = this.termPos.getPayloadLength();
            byte[] payload = this.termPos.getPayload(this.payloadBytes, 0);
            Decimal value = Decimal.fromByteArray(payload, payloadLength);
            if (!this.condition.check(value)) continue;
            this.docId = this.termPos.doc();
            this.findAllValues(value, pos, frequency);
            return true;
        }
        return false;
    }

    protected void findAllValues(Decimal value, int pos, int remainingPositions) throws IOException {
    }
}

