/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.decimal;

import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalLower;
import com.ibm.es.nuvo.util.decimal.DecimalUpper;
import java.util.Date;

public class DecimalRange
extends DecimalCondition {
    private DecimalLower lower;
    private DecimalUpper upper;

    public DecimalRange(Decimal lower, boolean lowerInclusive, Decimal upper, boolean upperInclusive) {
        super(false);
        this.lower = new DecimalLower(lower, lowerInclusive);
        this.upper = new DecimalUpper(upper, upperInclusive);
    }

    public DecimalRange(Date lower, boolean lowerInclusive, Date upper, boolean upperInclusive) {
        super(true);
        this.lower = new DecimalLower(lower, lowerInclusive);
        this.upper = new DecimalUpper(upper, upperInclusive);
    }

    public DecimalRange(DecimalLower lower, DecimalUpper upper) {
        super(lower.isDate());
        this.lower = lower;
        this.upper = upper;
    }

    public boolean check(Decimal value) {
        return this.lower.check(value) && this.upper.check(value);
    }

    public boolean equals(Object o) {
        if (o instanceof DecimalRange) {
            return this.lower.equals(((DecimalRange)o).lower) && this.upper.equals(((DecimalRange)o).upper);
        }
        return false;
    }

    public String toString(String operand) {
        return this.upper.toString(this.lower.toString(operand));
    }
}

