/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.decimal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;

public class Decimal {
    public static final int DEFAULT_PRECISION = 3;
    private long value;
    private int shift;
    private static long[] shiftFactors = new long[16];

    public Decimal(long value) {
        this.value = value;
        this.shift = 0;
    }

    public Decimal(long value, int shift) {
        this.value = value;
        this.shift = shift;
    }

    public Decimal(Date date) {
        this.value = date.getTime() / 1000L;
        this.shift = 0;
    }

    public Decimal(double value) {
        int precision;
        long longValue = Math.round(value * Math.pow(10.0, precision));
        for (precision = 3; precision > 0 && longValue % 10L == 0L; --precision) {
            longValue /= 10L;
        }
        this.value = longValue;
        this.shift = precision;
    }

    public Decimal(double value, int precision) {
        if (precision > 15) {
            throw new IllegalArgumentException();
        }
        long longValue = Math.round(value * Math.pow(10.0, precision));
        while (precision > 0 && longValue % 10L == 0L) {
            longValue /= 10L;
            --precision;
        }
        this.value = longValue;
        this.shift = precision;
    }

    public static Decimal parseDecimal(String value) throws NumberFormatException {
        return Decimal.parseDecimal(value, 3);
    }

    public static Decimal parseDecimal(String value, int precision) throws NumberFormatException {
        try {
            return new Decimal(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return new Decimal(Double.parseDouble(value), precision);
        }
    }

    public long longValue() {
        return this.value / shiftFactors[this.shift];
    }

    public Date dateValue() {
        return new Date(this.longValue() * 1000L);
    }

    public double doubleValue() {
        return (double)this.value / Math.pow(10.0, this.shift);
    }

    public byte[] toByteArray() {
        boolean negative = this.value < 0L;
        long posValue = negative ? -this.value : this.value;
        int valueBytes = 8 - Long.numberOfLeadingZeros(posValue) / 8;
        byte[] bytes = new byte[valueBytes + 1];
        bytes[0] = (byte)((negative ? 128 : 0) | this.shift & 0xF);
        for (int i = 0; i < valueBytes; ++i) {
            bytes[valueBytes - i] = (byte)(posValue & 0xFFL);
            posValue >>= 8;
        }
        return bytes;
    }

    public static Decimal fromByteArray(byte[] bytes) {
        return Decimal.fromByteArray(bytes, bytes.length);
    }

    public static Decimal fromByteArray(byte[] bytes, int length) {
        byte header = bytes[0];
        int shift = header & 0xF;
        boolean negative = (header & 0x80) != 0;
        long value = 0L;
        for (int i = 1; i < length; ++i) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
        }
        if (negative) {
            value = -value;
        }
        Decimal dec = new Decimal(value, shift);
        return dec;
    }

    public int compareTo(Decimal other) {
        long otherValue;
        long thisValue;
        if (this.shift < other.shift) {
            thisValue = this.value * shiftFactors[other.shift - this.shift];
            otherValue = other.value;
        } else {
            thisValue = this.value;
            otherValue = other.value * shiftFactors[this.shift - other.shift];
        }
        return thisValue > otherValue ? 1 : (thisValue < otherValue ? -1 : 0);
    }

    public boolean equals(Decimal other) {
        if (this == other) {
            return true;
        }
        return this.compareTo(other) == 0;
    }

    public boolean equals(Object other) {
        if (other instanceof Decimal) {
            return this.equals((Decimal)other);
        }
        return false;
    }

    public String toString() {
        if (this.shift == 0) {
            return Long.toString(this.value);
        }
        StringBuilder builder = new StringBuilder();
        long val = this.value;
        if (val < 0L && val != Long.MIN_VALUE) {
            val = -val;
            builder.append('-');
        }
        long shiftFactor = shiftFactors[this.shift];
        builder.append(Long.toString(val / shiftFactor));
        int periodPos = builder.length();
        builder.append(Long.toString(shiftFactor + val % shiftFactor));
        builder.setCharAt(periodPos, '.');
        return builder.toString();
    }

    public static void main(String[] args) throws IOException {
        String value;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((value = reader.readLine()) != null && value.length() != 0) {
            if (value.startsWith("compare")) {
                int blank = value.indexOf(" ", 8);
                String val1 = value.substring(8, blank);
                String val2 = value.substring(blank + 1);
                Decimal dec1 = Decimal.parseDecimal(val1, 10);
                Decimal dec2 = Decimal.parseDecimal(val2, 10);
                System.out.println("compare(" + dec1 + ", " + dec2 + ") = " + dec1.compareTo(dec2));
                continue;
            }
            System.out.println(Decimal.fromByteArray(Decimal.parseDecimal(value, 10).toByteArray()));
        }
    }

    static {
        long factor = 1L;
        for (int i = 0; i < 16; ++i) {
            Decimal.shiftFactors[i] = factor;
            factor *= 10L;
        }
    }
}

