/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util.databuffer;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.FileDeleteTask;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.ReferenceCountByteArrayInputStream;
import com.ibm.es.nuvo.util.databuffer.ReferenceCountFileInputStream;
import com.ibm.es.nuvo.util.databuffer.ReferenceCountListener;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataBufferOutputStream
extends OutputStream
implements ReferenceCountListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String NoData = "NoDataPresent";
    public static final int DefaultCapacity = 0x100000;
    public static final String DefaultPrefix = "IQQ";
    public static final String DefaultSuffix = "DataBuffer";
    public static final String DataBufferElement = "DataBuffer";
    private static final String DataFileNameElement = "DataFile";
    private File tempFile = null;
    private byte[] bytes;
    private OutputStream outputStream;
    private String prefix;
    private String suffix;
    private File directory = null;
    int capacity;
    int counter;
    boolean outputClosed;
    int referenceCount = 0;
    boolean removeOnLastClose;
    boolean allowFileDelete = true;
    Object mutex = new Object();

    public DataBufferOutputStream(int capacity, String prefix, String suffix, File directory) {
        this.capacity = capacity;
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
        this.counter = 0;
        this.outputStream = new ByteArrayOutputStream(capacity);
        this.outputClosed = false;
        this.removeOnLastClose = false;
    }

    public DataBufferOutputStream() {
        this(0x100000, DefaultPrefix, "DataBuffer", null);
        this.initializeDataDirectory();
    }

    public DataBufferOutputStream(int capacity) {
        this(capacity, DefaultPrefix, "DataBuffer", null);
        this.initializeDataDirectory();
    }

    public void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.outputStream.write((byte)b);
    }

    public boolean isOutputClosed() {
        return this.outputClosed;
    }

    public void close() throws IOException {
        if (this.isCachingInMemory()) {
            this.bytes = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        this.outputStream.close();
        this.outputClosed = true;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void write(byte[] b) throws IOException {
        this.ensureCapacity(b.length);
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        this.outputStream.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws DataBufferException {
        if (this.bytes == null && this.tempFile == null) {
            throw new DataBufferException(new Message("G0055E.DATA_BUFFER_CACHE_REMOVED"), null);
        }
        if (!this.outputClosed) {
            throw new DataBufferException(new Message("G0056E.DATA_BUFFER_CACHE_NOT_READY"), null);
        }
        if (this.isCachingInMemory()) {
            ++this.referenceCount;
            return new ReferenceCountByteArrayInputStream(this.bytes, this);
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                ReferenceCountFileInputStream s = new ReferenceCountFileInputStream(this.tempFile, this);
                ++this.referenceCount;
                return s;
            }
        }
        catch (FileNotFoundException e) {
            throw new DataBufferException(new Message("G0056E.DATA_BUFFER_CACHE_NOT_READY"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            this.removeOnLastClose = true;
        }
        this.checkReference();
    }

    public void writeTo(XMLTagger xmlTagger) throws IOException {
        this.forceDataToDisk(true);
        xmlTagger.startElement("DataBuffer");
        xmlTagger.startElement(DataFileNameElement);
        if (this.tempFile != null) {
            xmlTagger.writeText(this.tempFile.getName());
        } else {
            xmlTagger.writeText(NoData);
        }
        xmlTagger.endElement(DataFileNameElement);
        xmlTagger.endElement("DataBuffer");
    }

    public void setDataFileName(String fileName) {
        File f;
        this.tempFile = f = new File(this.directory, fileName);
        this.counter = -1;
        this.outputClosed = true;
    }

    public String getDataFileName() {
        String name = null;
        if (this.tempFile != null) {
            name = this.tempFile.getAbsolutePath();
        }
        return name;
    }

    public void validateAfterRestore() throws DataBufferException {
        if (this.tempFile != null && !this.tempFile.exists()) {
            throw new DataBufferException(new Message("G0152E.DATA_BUFFER_DATA_FILE_MISSING", this.tempFile.getAbsolutePath()), null);
        }
    }

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + "DataBuffer" + "/";
        tree.addCallMethod(parentPath + DataFileNameElement, "setDataFileName");
    }

    private void initializeDataDirectory() {
        String docQueueDir;
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        if (globalConfig != null && (docQueueDir = globalConfig.getDocQueueDirectory()) != null) {
            this.directory = new File(docQueueDir);
        }
        if (this.directory == null || !this.directory.exists()) {
            String tempDirectory = System.getProperty("java.io.tmpdir");
            this.directory = new File(tempDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReference() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.referenceCount <= 0 && this.removeOnLastClose) {
                if (this.tempFile != null && this.allowFileDelete) {
                    FileDeleteTask task;
                    boolean deleteSuccessful = this.tempFile.delete();
                    if (!deleteSuccessful && (task = GlobalSystem.getSingleInstance().getFileDeleteTask()) != null) {
                        task.addFileToBeDeleted(this.tempFile);
                    }
                    this.tempFile = null;
                } else {
                    this.bytes = null;
                }
            }
        }
    }

    private void ensureCapacity(int size) throws IOException {
        if (this.isCachingInMemory()) {
            if (this.counter + size > this.capacity) {
                this.tempFile = File.createTempFile(this.prefix, this.suffix, this.directory);
                byte[] bytesToWrite = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                this.outputStream = new FileOutputStream(this.tempFile);
                this.outputStream.write(bytesToWrite);
                this.counter = -1;
            } else {
                this.counter += size;
            }
        }
    }

    private boolean isCachingInMemory() {
        return this.counter >= 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        Object object = this.mutex;
        synchronized (object) {
            --this.referenceCount;
        }
        this.checkReference();
    }

    public File forceDataToDisk(boolean preventFileDelete) throws IOException {
        this.allowFileDelete = !preventFileDelete;
        File dataFile = this.tempFile;
        if (this.isCachingInMemory() && this.bytes != null) {
            this.capacity = 0;
            this.ensureCapacity(1);
            dataFile = this.tempFile;
        }
        this.flush();
        return dataFile;
    }
}

