/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDOMUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static DocumentBuilderFactory NonValidatingDOMBuilderFactory = null;

    private static synchronized DocumentBuilderFactory getNonValidatingDOMFactory() throws ParserConfigurationException {
        if (null == NonValidatingDOMBuilderFactory) {
            NonValidatingDOMBuilderFactory = DocumentBuilderFactory.newInstance();
            NonValidatingDOMBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            NonValidatingDOMBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
        }
        return NonValidatingDOMBuilderFactory;
    }

    public static Document readAsNonValidatingDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Document xmlDoc = null;
        DocumentBuilder builder = XMLDOMUtils.getNonValidatingDOMFactory().newDocumentBuilder();
        xmlDoc = builder.parse(is);
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readAsNonValidatingDOM(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fis = new FileInputStream(xmlFile);
        Document doc = null;
        try {
            doc = XMLDOMUtils.readAsNonValidatingDOM(fis);
        }
        finally {
            fis.close();
        }
        return doc;
    }

    public static void writeDOM(Document xmlDoc, OutputStream os) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DocumentType docType = xmlDoc.getDoctype();
        if (null != docType) {
            transformer.setOutputProperty("doctype-public", docType.getPublicId());
            transformer.setOutputProperty("doctype-system", docType.getSystemId());
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(xmlDoc);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDOM(Document xmlDoc, File targetFile) throws FileNotFoundException, TransformerException {
        FileOutputStream fos = new FileOutputStream(targetFile, false);
        try {
            XMLDOMUtils.writeDOM(xmlDoc, fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Vector<Element> getAllNodes(Document xmlDoc, String xPath) {
        Vector<Element> foundElements = new Vector<Element>();
        Vector<String> elementNames = XMLDOMUtils.getElementNamesFromXPath(xPath);
        int desiredDepth = elementNames.size();
        Node tempNode = null;
        NodeList nodeList = xmlDoc.getElementsByTagName(elementNames.lastElement());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            tempNode = nodeList.item(i);
            if (!(tempNode instanceof Element) || desiredDepth != XMLDOMUtils.countDepth(tempNode)) continue;
            Node tempNode2 = tempNode;
            boolean namesEqual = true;
            int currentDepth = desiredDepth - 1;
            while (!(tempNode2 instanceof Document) && namesEqual) {
                if (tempNode2 instanceof Element) {
                    Element tempElement = (Element)tempNode2;
                    namesEqual = elementNames.get(currentDepth).equals(tempElement.getTagName());
                } else {
                    namesEqual = false;
                }
                tempNode2 = tempNode2.getParentNode();
                --currentDepth;
            }
            if (!namesEqual) continue;
            foundElements.add((Element)tempNode);
        }
        return foundElements;
    }

    public static Vector<Element> getAllNodes(Document xmlDoc, String xPath, String elementValue) {
        Vector<Element> elements = XMLDOMUtils.getAllNodes(xmlDoc, xPath);
        if (elementValue != null) {
            for (int i = elements.size() - 1; i >= 0; --i) {
                Element e = elements.get(i);
                if (elementValue.equals(e.getTextContent())) continue;
                elements.remove(i);
            }
        }
        return elements;
    }

    public static Vector<Element> getAllNodes(Document xmlDoc, String xPath, String elementValue, String filterXPath, String filterElementValue) {
        Vector<Element> elements = XMLDOMUtils.getAllNodes(xmlDoc, xPath, elementValue);
        if (filterXPath != null && filterElementValue != null && filterXPath.length() > 0) {
            Vector<Element> relatedElements = XMLDOMUtils.getAllNodes(xmlDoc, filterXPath, filterElementValue);
            for (int i = elements.size() - 1; i >= 0; --i) {
                Element e = elements.get(i);
                boolean keepElement = false;
                for (int j = relatedElements.size() - 1; j >= 0 && !keepElement; --j) {
                    Element relatedElem = relatedElements.get(j);
                    keepElement = XMLDOMUtils.areNodesFromSameBranch(e, relatedElem);
                }
                if (keepElement) continue;
                elements.remove(i);
            }
        }
        return elements;
    }

    public static int countDepth(Node node) {
        int currentDepth = 0;
        Node tempNode = null;
        tempNode = node;
        while (!(tempNode instanceof Document)) {
            tempNode = tempNode.getParentNode();
            ++currentDepth;
        }
        return currentDepth;
    }

    public static String getFullName(Node node) {
        StringBuilder sb = new StringBuilder(100);
        Node tempNode = null;
        tempNode = node;
        while (!(tempNode instanceof Document)) {
            sb.insert(0, tempNode.getNodeName());
            sb.insert(0, "/");
            tempNode = tempNode.getParentNode();
        }
        return sb.toString();
    }

    public static Vector<String> getElementNamesFromXPath(String xPath) {
        Vector<String> names = new Vector<String>();
        if (xPath != null && xPath.length() > 0) {
            StringTokenizer st = new StringTokenizer(xPath, "/");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                names.add(s);
            }
        }
        return names;
    }

    public static void setNodeValueTo(Element node, String textValue, HashMap<String, String> attributes) {
        if (textValue != null) {
            node.setTextContent(textValue);
        }
        if (attributes != null && attributes.size() > 0) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                node.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public static boolean areNodesFromSameBranch(Element e1, Element e2) {
        boolean sameBranch = true;
        boolean keepGoing = true;
        Vector<Element> parentList1 = XMLDOMUtils.getParentList(e1);
        Vector<Element> parentList2 = XMLDOMUtils.getParentList(e2);
        for (int count = 0; keepGoing && sameBranch && count < parentList1.size() && count < parentList2.size(); ++count) {
            Element parent2;
            Element parent1 = parentList1.get(count);
            if (parent1 == (parent2 = parentList2.get(count))) continue;
            keepGoing = false;
            if (!parent1.getTagName().equals(parent2.getTagName())) continue;
            sameBranch = false;
        }
        return sameBranch;
    }

    public static Vector<Element> getParentList(Element e) {
        Vector<Element> parentList = new Vector<Element>();
        parentList.add(e);
        Node tempNode = e.getParentNode();
        while (tempNode != null && !(tempNode instanceof Document)) {
            if (tempNode instanceof Element) {
                parentList.add(0, (Element)tempNode);
                tempNode = tempNode.getParentNode();
                continue;
            }
            tempNode = null;
        }
        return parentList;
    }

    public static void filterListByAttribute(Vector<Element> elements, String attrName, String attrValue) {
        if (attrName != null) {
            for (int i = elements.size() - 1; i >= 0; --i) {
                Element e = elements.get(i);
                boolean keepElement = true;
                if (e.hasAttribute(attrName)) {
                    if (attrValue != null && !attrValue.equals(e.getAttribute(attrName))) {
                        keepElement = false;
                    }
                } else {
                    keepElement = false;
                }
                if (keepElement) continue;
                elements.remove(i);
            }
        }
    }

    public static Element getElement(String path, Document document) {
        Element[] elements = XMLDOMUtils.getElements(path, document, 1);
        if (null == elements || 0 == elements.length) {
            return null;
        }
        return elements[0];
    }

    public static Element[] getElements(String path, Document document, int count) {
        String[] values;
        ArrayList<Element> retElements = new ArrayList<Element>();
        if (null == path) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((values = path.split("/")) == null) {
            return null;
        }
        Node curNode = document.getFirstChild();
        int i = 0;
        Stack<Node> parentStack = new Stack<Node>();
        while (i < values.length && curNode != null) {
            if (curNode instanceof Element) {
                String[] elementAttribute = values[i].split("@");
                if (curNode.getNodeName().equals(elementAttribute[0])) {
                    NamedNodeMap attributes;
                    Node namedAttribute;
                    String attributeToFind = null;
                    String attributeToFindValue = null;
                    if (elementAttribute.length > 1) {
                        String[] splits = elementAttribute[1].split("=");
                        attributeToFind = splits[0];
                        attributeToFindValue = splits[1];
                    }
                    if (!(null == attributeToFind || null != (namedAttribute = (attributes = curNode.getAttributes()).getNamedItem(attributeToFind)) && namedAttribute.getNodeValue().equals(attributeToFindValue))) {
                        curNode = curNode.getNextSibling();
                        continue;
                    }
                    if (i == values.length - 1 && curNode instanceof Element) {
                        retElements.add((Element)curNode);
                        if (retElements.size() == count) {
                            break;
                        }
                    } else {
                        parentStack.push(curNode);
                        curNode = curNode.getFirstChild();
                        ++i;
                        continue;
                    }
                }
            }
            if (null != (curNode = curNode.getNextSibling()) || parentStack.size() <= 0) continue;
            --i;
            curNode = ((Node)parentStack.pop()).getNextSibling();
        }
        if (retElements.size() > 0) {
            Element[] elements = new Element[retElements.size()];
            return retElements.toArray(elements);
        }
        return null;
    }
}

