/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.logging.Level;

public class WindowsRegistryValidationTask
implements Runnable {
    private static final String RegistryExe = "OmniFindWinService.exe /getStopTime";
    private int minTime = 0;

    public WindowsRegistryValidationTask(int minimumTime) {
        this.minTime = minimumTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        if (!globalConfig.isWindows()) {
            return;
        }
        String registryProcessCmd = globalConfig.getBinPath() + File.separator + RegistryExe;
        Process registryProcess = null;
        try {
            registryProcess = Runtime.getRuntime().exec(registryProcessCmd);
            InputStream is = registryProcess.getInputStream();
            if (is != null) {
                int windowsShutdownValue;
                BufferedReader processOutput = new BufferedReader(new InputStreamReader(is));
                String outputLine = processOutput.readLine();
                if (outputLine != null && outputLine.length() > 0 && (windowsShutdownValue = Integer.valueOf(outputLine.trim()).intValue()) >= 0 && this.minTime > windowsShutdownValue && Loggers.logger.isLoggable(Level.WARNING)) {
                    Message msg = new Message("G0164W.WINDOWS_SERVICES_SHUTDOWN_TIME_TOO_LOW", NumberFormat.getInstance().format(windowsShutdownValue), NumberFormat.getInstance().format(this.minTime));
                    Loggers.logger.log(Level.WARNING, msg);
                }
                processOutput.close();
                is.close();
            }
        }
        catch (IOException e) {
        }
        finally {
            if (registryProcess != null) {
                registryProcess.destroy();
            }
        }
    }
}

