/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.util.Vint8;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Vlong8 {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static int bytesNeeded(long number) {
        if ((number & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((number & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((number & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((number & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((number & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((number & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((number & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((number & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        return 9;
    }

    public static int encode(long number, byte[] dest, int start) {
        if ((number & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dest[start] = (byte)number;
            return 1;
        }
        if ((number & 0xFFFFFFFFFFFFC000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 1] = (byte)(number & 0x7FL);
            return 2;
        }
        if ((number & 0xFFFFFFFFFFE00000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 1] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 2] = (byte)(number & 0x7FL);
            return 3;
        }
        if ((number & 0xFFFFFFFFF0000000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
            dest[start + 1] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 2] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 3] = (byte)(number & 0x7FL);
            return 4;
        }
        if ((number & 0xFFFFFFF800000000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0xFFFFFFFFF0000000L) >> 28);
            dest[start + 1] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
            dest[start + 2] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 3] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 4] = (byte)(number & 0x7FL);
            return 5;
        }
        if ((number & 0xFFFFFC0000000000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0x3F800000000L) >> 35);
            dest[start + 1] = (byte)(0x80L | (number & 0xFFFFFFFFF0000000L) >> 28);
            dest[start + 2] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
            dest[start + 3] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 4] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 5] = (byte)(number & 0x7FL);
            return 6;
        }
        if ((number & 0xFFFE000000000000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0x1FC0000000000L) >> 42);
            dest[start + 1] = (byte)(0x80L | (number & 0x3F800000000L) >> 35);
            dest[start + 2] = (byte)(0x80L | (number & 0xFFFFFFFFF0000000L) >> 28);
            dest[start + 3] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
            dest[start + 4] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 5] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 6] = (byte)(number & 0x7FL);
            return 7;
        }
        if ((number & 0xFF00000000000000L) == 0L) {
            dest[start] = (byte)(0x80L | (number & 0xFE000000000000L) >> 49);
            dest[start + 1] = (byte)(0x80L | (number & 0x1FC0000000000L) >> 42);
            dest[start + 2] = (byte)(0x80L | (number & 0x3F800000000L) >> 35);
            dest[start + 3] = (byte)(0x80L | (number & 0xFFFFFFFFF0000000L) >> 28);
            dest[start + 4] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
            dest[start + 5] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
            dest[start + 6] = (byte)(0x80L | (number & 0x3F80L) >> 7);
            dest[start + 7] = (byte)(number & 0x7FL);
            return 8;
        }
        dest[start] = (byte)(0x80L | (number & 0x7F00000000000000L) >> 56);
        dest[start + 1] = (byte)(0x80L | (number & 0xFE000000000000L) >> 49);
        dest[start + 2] = (byte)(0x80L | (number & 0x1FC0000000000L) >> 42);
        dest[start + 3] = (byte)(0x80L | (number & 0x3F800000000L) >> 35);
        dest[start + 4] = (byte)(0x80L | (number & 0xFFFFFFFFF0000000L) >> 28);
        dest[start + 5] = (byte)(0x80L | (number & 0xFE00000L) >> 21);
        dest[start + 6] = (byte)(0x80L | (number & 0x1FC000L) >> 14);
        dest[start + 7] = (byte)(0x80L | (number & 0x3F80L) >> 7);
        dest[start + 8] = (byte)(number & 0x7FL);
        return 9;
    }

    public static long decode(byte[] bytes, Vint8.Position pos) {
        long value = 0L;
        while (true) {
            byte first = bytes[pos.pos];
            ++pos.pos;
            value |= (long)(first & 0x7F);
            if ((first & 0x80) == 0) {
                return value;
            }
            value <<= 7;
        }
    }

    public static long decode(InputStream in) throws IOException {
        long value = 0L;
        while (true) {
            int first;
            if ((first = in.read()) < 0) {
                throw new EOFException();
            }
            value |= (long)(first & 0x7F);
            if ((first & 0x80) == 0) {
                return value;
            }
            value <<= 7;
        }
    }

    public static void main(String[] args) {
        long maxLong = Long.MAX_VALUE;
        int bytesNeeded = Vlong8.bytesNeeded(maxLong);
        byte[] data = new byte[bytesNeeded];
        Vlong8.encode(maxLong, data, 0);
        Vint8.Position pos = new Vint8.Position(0);
        long decodedLong = Vlong8.decode(data, pos);
        assert (maxLong == decodedLong);
    }
}

