/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VInt4 {
    public static StreamState start() {
        return new StreamState();
    }

    public static BufferState start(int bufferSize) {
        return new BufferState(bufferSize);
    }

    public static int finish(byte[] dest, BufferState state) {
        if (state.usedNibble) {
            dest[state.position] = (byte)(state.b & 0xF0);
            state.usedNibble = false;
            ++state.position;
        }
        return state.position;
    }

    public static void finish(OutputStream out, StreamState state) throws IOException {
        if (state.usedNibble) {
            out.write(state.b & 0xF0);
            state.usedNibble = false;
        }
    }

    public static int readNumber(byte[] src, BufferState state) {
        int number = 0;
        int shift = 0;
        byte nibble = 0;
        do {
            nibble = VInt4.readNibble(src, state);
            if (state.exhausted) {
                return 0;
            }
            number |= (nibble & 7) << shift;
            shift += 3;
        } while ((nibble & 8) != 0);
        return number;
    }

    public static int readNumber(InputStream input, StreamState state) throws IOException {
        int number = 0;
        int shift = 0;
        byte nibble = 0;
        do {
            nibble = VInt4.readNibble(input, state);
            if (state.exhausted) {
                return 0;
            }
            number |= (nibble & 7) << shift;
            shift += 3;
        } while ((nibble & 8) != 0);
        return number;
    }

    public boolean addNumber(byte[] dest, BufferState state, int num) {
        while (num > 7) {
            byte nibble = (byte)(num & 7 | 8);
            if (!VInt4.addNibble(dest, state, nibble)) {
                return false;
            }
            num >>= 3;
        }
        return VInt4.addNibble(dest, state, (byte)num);
    }

    public void addNumber(OutputStream out, StreamState state, int num) throws IOException {
        while (num > 7) {
            byte nibble = (byte)(num & 7 | 8);
            VInt4.addNibble(out, state, nibble);
            num >>= 3;
        }
        VInt4.addNibble(out, state, (byte)num);
    }

    public int bytesUsed(BufferState state) {
        return state.position;
    }

    private static byte readNibble(byte[] src, BufferState state) {
        byte nibble;
        if (!state.usedNibble) {
            if (state.position >= state.limit) {
                state.exhausted = true;
                return 0;
            }
            state.b = src[state.position];
            nibble = (byte)(state.b >> 4 & 0xF);
            state.usedNibble = true;
            ++state.position;
        } else {
            nibble = (byte)(state.b & 0xF);
            state.usedNibble = false;
        }
        return nibble;
    }

    private static boolean addNibble(byte[] dest, BufferState state, byte nibble) {
        if (!state.usedNibble) {
            if (state.position >= state.limit) {
                return false;
            }
            state.b = (byte)(nibble << 4 & 0xF0);
            state.usedNibble = true;
        } else {
            dest[state.position] = (byte)(state.b & 0xF0 | nibble);
            state.usedNibble = false;
            ++state.position;
        }
        return true;
    }

    private static byte readNibble(InputStream input, StreamState state) throws IOException {
        byte nibble;
        if (!state.usedNibble) {
            state.b = (byte)input.read();
            if (state.b == 0) {
                state.exhausted = true;
                return 0;
            }
            nibble = (byte)(state.b >> 4 & 0xF);
            state.usedNibble = true;
        } else {
            nibble = (byte)(state.b & 0xF);
            state.usedNibble = false;
        }
        return nibble;
    }

    private static void addNibble(OutputStream out, StreamState state, byte nibble) throws IOException {
        if (!state.usedNibble) {
            state.b = (byte)(nibble << 4);
            state.usedNibble = true;
        } else {
            out.write(state.b & 0xF0 | nibble);
            state.usedNibble = false;
        }
    }

    public static class BufferState {
        public int limit;
        public int position = 0;
        public boolean usedNibble = false;
        public byte b;
        public boolean exhausted;

        public BufferState(int bufferSize) {
            this.limit = bufferSize;
            this.exhausted = false;
        }
    }

    public static class StreamState {
        public boolean usedNibble = false;
        public byte b = 0;
        public boolean exhausted = false;
    }
}

