/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.net.URI;
import java.net.URISyntaxException;

public class URLUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final char[] QUERY_SEP = new char[]{'?', '!', '#'};

    public static int computeURLDepth(String urlString) {
        int depth = 0;
        try {
            int exclPos;
            String query;
            String path;
            int pos;
            String host;
            URI uri = new URI(urlString);
            if (uri.isOpaque()) {
                return 1;
            }
            if (uri.isAbsolute() && (host = uri.getHost()) != null) {
                pos = host.indexOf(46);
                while (pos >= 0) {
                    ++depth;
                    pos = host.indexOf(46, pos + 1);
                }
            }
            if (depth < 2) {
                depth = 2;
            }
            if ((path = uri.getPath()) != null) {
                pos = path.indexOf(47);
                while (pos >= 0) {
                    ++depth;
                    pos = path.indexOf(47, pos + 1);
                }
                if (path.endsWith("index.html") || path.endsWith("index.htm") || path.endsWith("/")) {
                    --depth;
                }
            }
            if (uri.getFragment() != null) {
                ++depth;
            }
            if ((query = uri.getQuery()) == null && path != null && (exclPos = path.indexOf(33)) > 0) {
                query = path.substring(exclPos + 1);
            }
            if (query != null) {
                ++depth;
                int pos2 = query.indexOf(38);
                while (pos2 >= 0) {
                    ++depth;
                    pos2 = query.indexOf(38, pos2 + 1);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return depth;
    }

    public static final String getHostname(String url) {
        try {
            String host;
            URI uri = new URI(url);
            if (uri.isOpaque()) {
                return null;
            }
            if (uri.isAbsolute() && (host = uri.getHost()) != null) {
                int port = uri.getPort();
                if (port != -1) {
                    StringBuilder hostname = new StringBuilder();
                    hostname.append(host).append(':').append(Integer.toString(port));
                    return hostname.toString();
                }
                return host;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static final String getFileExtension(String url) {
        String ext = null;
        if (url != null) {
            int length = url.length();
            int protocol = url.indexOf(58);
            if (protocol != -1) {
                while (protocol < length - 1 && url.charAt(protocol + 1) == '/') {
                    ++protocol;
                }
            }
            int end = -1;
            for (int i = 0; i < QUERY_SEP.length; ++i) {
                int index = url.indexOf(QUERY_SEP[i]);
                if (index == -1 || end != -1 && index >= end) continue;
                end = index;
            }
            if (end != -1) {
                url = url.substring(0, end);
            }
            int lastDot = url.lastIndexOf(46);
            int lastSlash = url.lastIndexOf(47);
            if (lastDot != -1 && lastSlash != -1 && lastSlash < lastDot && lastSlash > protocol) {
                ext = url.substring(lastDot + 1);
            }
        }
        return ext != null && ext.length() != 0 ? ext.toLowerCase() : null;
    }
}

