/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long milliSecsPerDay = 86400000L;

    public static long timeInMillis(long time, TimeUnit unit) {
        if (unit == TimeUnit.MILLISECONDS) {
            return time;
        }
        if (unit == TimeUnit.SECONDS) {
            return time * 1000L;
        }
        if (unit == TimeUnit.MICROSECONDS) {
            return time / 1000L;
        }
        if (unit == TimeUnit.NANOSECONDS) {
            return time / 1000000L;
        }
        throw new IllegalArgumentException("Invalid time units " + (Object)((Object)unit));
    }

    public static long timeoutTime(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("nonpositive timeout interval");
        }
        long t0 = System.currentTimeMillis();
        return t0 + TimeUtils.timeInMillis(timeout, unit);
    }

    public static int computeDaysSinceEpoch(long timeMillis) {
        int dateDays = (int)(timeMillis / 86400000L);
        return dateDays > 0 ? dateDays : 0;
    }
}

