/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private InputStream sourceStream;
    private OutputStream outputStream;

    public TeeInputStream(InputStream sourceStream, OutputStream outputStream) {
        this.sourceStream = sourceStream;
        this.outputStream = outputStream;
    }

    public int available() throws IOException {
        return this.sourceStream.available();
    }

    public void close() throws IOException {
        this.sourceStream.close();
        this.outputStream.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int c = this.sourceStream.read();
        if (c != -1) {
            this.outputStream.write(c);
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int numRead = this.sourceStream.read(b);
        if (numRead != -1) {
            this.outputStream.write(b, 0, numRead);
        }
        return numRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numRead = this.sourceStream.read(b, off, len);
        if (numRead != -1) {
            this.outputStream.write(b, off, numRead);
        }
        return numRead;
    }

    public long skip(long n) throws IOException {
        return this.sourceStream.skip(n);
    }
}

