/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean noData(String s) {
        return StringUtils.noData(s, null);
    }

    public static boolean noData(String s, String[] tr) {
        boolean someData;
        if (StringUtils.empty(s)) {
            return true;
        }
        String t = s.trim();
        boolean bl = someData = !StringUtils.empty(t);
        if (someData && tr != null && tr.length >= 1) {
            tr[0] = t;
        }
        return !someData;
    }

    public static String replaceParameter(String source, String parameter, String replacement) {
        if (StringUtils.empty(source)) {
            return source;
        }
        Properties props = new Properties();
        props.setProperty(parameter, replacement);
        return StringUtils.replaceParameters(source, props);
    }

    public static String replaceWhitneyHome(String source) {
        String whitneyHome;
        if (source.indexOf("${whitney.home}") >= 0 && !StringUtils.empty(whitneyHome = System.getProperty("whitney.home"))) {
            source = StringUtils.replaceParameter(source, "${whitney.home}", whitneyHome);
        }
        return source;
    }

    public static String replaceParameters(String source, Properties props) {
        if (StringUtils.empty(source) || props == null || props.isEmpty()) {
            return source;
        }
        StringBuffer in = new StringBuffer(source);
        StringBuffer out = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> next = it.next();
            String target = (String)next.getKey();
            if (StringUtils.empty(target)) {
                throw new IllegalArgumentException("Empty replacement string");
            }
            int targetLen = target.length();
            String replacement = (String)next.getValue();
            boolean replaceWithEmpty = StringUtils.empty(replacement);
            int i = 0;
            int count = in.length();
            while (i < count) {
                int foundAt = in.indexOf(target, i);
                if (foundAt < 0) {
                    out.append(in.substring(i));
                    break;
                }
                out.append(in.substring(i, foundAt));
                if (!replaceWithEmpty) {
                    out.append(replacement);
                }
                i = foundAt + targetLen;
            }
            if (!it.hasNext()) continue;
            StringBuffer temp = in;
            in = out;
            out = temp;
            int len = out.length();
            if (len <= 0) continue;
            out.delete(0, len);
        }
        return out.toString();
    }

    public static String buildFileListString(Vector<String> fileNames) {
        String newLine = System.getProperty("line.separator", ",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fileNames.size(); ++i) {
            sb.append(fileNames.elementAt(i));
            sb.append(newLine);
        }
        return sb.toString();
    }

    public static String readerToString(Reader reader) throws IOException {
        int ch;
        StringBuilder builder = new StringBuilder();
        while ((ch = reader.read()) >= 0) {
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static boolean startsWithIgnoreCase(String source, String substring) {
        boolean startsWith = false;
        if (source != null && substring != null && source.length() >= substring.length()) {
            String tempStr = source.substring(0, substring.length());
            startsWith = tempStr.equalsIgnoreCase(substring);
        }
        return startsWith;
    }
}

